; Infernal Rhythm
; a hard sync experimentation
; by Stefano Tognon in 2002
; a repeat tune of 1:48 minute

  org 2049
  .byte $0b,$08,$e8,$03,$9e,"2061",0,0,0

  processor 6502
  org 2061

      ldx  #$00
      stx  53280
      inx
      stx  53281

      jsr  $E544

      ldx  #$05
      ldy  #$01
      jsr  $E50C                    ; set x/y coord

      lda  #<S1
      ldy  #>S1
      jsr  $AB1E                    ; write a string

      ldy  #$01
      ldx  #$06
      jsr  $E50C                    ; set x/y coord

      lda  #<S2
      ldy  #>S2
      jsr  $AB1E                    ; write a string

      ldy  #$06
      ldx  #$07
      jsr  $E50C                    ; set x/y coord

      lda  #<S2_
      ldy  #>S2_
      jsr  $AB1E                    ; write a string

      ldy  #$01
      ldx  #$09
      jsr  $E50C                    ; set x/y coord

      lda  #<S3
      ldy  #>S3
      jsr  $AB1E                    ; write a string

      ldy  #$01
      ldx  #$0a
      jsr  $E50C                    ; set x/y coord

      lda  #<S4
      ldy  #>S4
      jsr  $AB1E                    ; write a string

      ldy  #$01
      ldx  #$0c
      jsr  $E50C                    ; set x/y coord

      lda  #<S5
      ldy  #>S5
      jsr  $AB1E                    ; write a string

      ldy  #$01
      ldx  #$0d
      jsr  $E50C                    ; set x/y coord

      lda  #<S6
      ldy  #>S6
      jsr  $AB1E                    ; write a string

      lda  #$00
      jsr  $1000
      jsr  initraster
aaa:  jmp  aaa

initraster:     sei
                lda #<raster
                sta $0314
                lda #>raster
                sta $0315
                lda #50                         ;Set low bits of raster
                sta $d012                       ;position
                lda $d011
                and #$7f                        ;Set high bit of raster
                sta $d011                       ;position (0)
                lda #$7f                        ;Set timer interrupt off
                sta $dc0d
                lda #$01                        ;Set raster interrupt on
                sta $d01a
                lda $dc0d                       ;Acknowledge timer interrupt
                cli
                rts

raster:         nop
                nop
                nop
                nop
                nop
                nop
                nop
                lda $d012
                sta raster_cmp+1
                inc $d020
                jsr $1003                       ;Play music and measure
                lda $d012                       ;rastertime it took to
                dec $d020                       ;execute
                sec
raster_cmp:     sbc #$00
                sta currraster
                cmp maxraster
                bcc raster_skip
                sta maxraster
raster_skip:    dec $d019
                jmp $ea31

maxraster:      .byte 0
currraster:     .byte 0

S1:
  .byte  "INFERNAL RHYTHM",0
S2:
  .byte  "A HARD SYNC EXPERIMENT",0
S2_:
  .byte  "BY STEFANO TOGNON (2002)",0
S3:
  .byte  "NEED A REAL C64 OR AN ACCURATE PLAYER",0
S4:
  .byte  "TRY TO LISTEN FOR IT AND YOU WILL",0
S5:
  .byte  "BE CAPTURED BY THE INFERNAL RHYTHM...",0
S6:
  .byte  "YOU ARE ADVISED...",0

 org 4096

 .incbin infernal.bin
