#include <stdio.h>
#include <stdlib.h>
#include <string.h>

int main(int argc, char **argv)
{
    unsigned char buffer[65526];
    int size;
    int i;
    FILE *f;
    
    if (argc < 3)
    {
        printf("usage : %s <prg> <file.c>\n", argv[0]);
        exit(-1);
    }
    f = fopen(argv[1], "rb");
    if (!f)
    {
        printf("cannot open \"%s\"\n", argv[1]);
        exit(-1);
    }
    size = fread(buffer, 1, sizeof(buffer), f);
    fclose(f);
    f = fopen(argv[2],"w");
    if (!f)
    {
        printf("cannot open \"%s\"\n", argv[2]);
        exit(-1);
    }    
    fprintf(f, "unsigned char ef3usbprg[] = {\n");
    for(i=0; i < size; ++i)
    {
        fprintf(f, "0x%02x", buffer[i]);
        if (i < size-1)
        {
            fprintf(f, ",");
        }
        if ((i & 15) == 15)
        {
            fprintf(f, "\n");
        }
    }
    fprintf(f,"};\n");
    fclose(f);
    return 0;
}
