;=========================================================
;
; "Too Big Sprite Font"
; [NOT PARTICIPATING IN THE 256 BYTE SPRITE FONT COMPO, obviously]
; (C) Copyright 2019 ccr/TNSP^PWP <ccr@tnsp.org>
;
; This code is licensed under WTFPL (see COPYING.txt)
;
; This code is in XA compatible assembler format.
; It also requires data files built by the Makefile
; and mkfontdata utility.
;
; This is meant to be used in conjunction with vw_toobig.bin
; by Shadow, which is linked into toobig.prg
;
;=========================================================

	spr_data		= $2000

	zp_start        = $a0

	; We use quite a few zp variables
	spr_ptr			= zp_start + 0
	spr_glyph_ptr	= zp_start + 2
	glyph_draw_ptr 	= zp_start + 4

	flag_mirror_x	= zp_start + 6
	flag_mirror_y	= zp_start + 7
	glyph_offs 		= zp_start + 8
	glyph_offs_delta = zp_start + 9
	glyph_row 		= zp_start + 10
	tmpbyte 		= zp_start + 11
	glyph_counter	= zp_start + 12

;=========================================================

	; Length of font definition data
	font_defs_len	= font_defs_end - font_defs

	; Number of characters defined
	nfont_defs		= ((font_defs_len * 8) / (5 * 9))

;=========================================================

	orig = $0900
	.word orig		; PRG load address
	* = orig

;=========================================================

m_start:
	; Initialize data pointers
	lda #<spr_data
	sta spr_ptr
	lda #>spr_data
	sta spr_ptr + 1

	; Render the characters
m_loop:

	; Set spr_glyph_ptr from current spr_ptr, but also add 64 to spr_ptr
	lda spr_ptr
	sta spr_glyph_ptr
	clc
	adc #64	; size of sprite
	sta spr_ptr

	lda spr_ptr + 1
	sta spr_glyph_ptr + 1
	adc #0
	sta spr_ptr + 1

	; Draw all the 9 glyph segments
	jsr render_glyph_seg_triad
	jsr render_glyph_seg_triad
	jsr render_glyph_seg_triad

	; Loop until done
	dec font_counter
	bne m_loop

m_finish:
	rts


;=========================================================
; Decode and render one character to a sprite
;=========================================================
render_glyph_seg_triad:
	jsr spr_glyph_ptr_inc_1
	jsr spr_glyph_ptr_inc_1
;	jsr spr_glyph_ptr_inc_x
;	rts

;spr_glyph_ptr_inc_x:
	jsr render_glyph_seg
	lda spr_glyph_ptr
	clc
	adc #(3*7 - 2)
sp0:
	sta spr_glyph_ptr
	bcc sp1
	inc spr_glyph_ptr + 1
sp1:
	rts


spr_glyph_ptr_inc_1:
	jsr render_glyph_seg
	lda spr_glyph_ptr
	clc
	adc #1
;	jmp sp0	; ^^^
	bcc sp0	; C = 0 always


;=========================================================
; Decode and render one character "segment"
; glyph_draw_ptr = pointer to sprite data
;=========================================================
render_glyph_seg:
	; Set segment glyph_draw_ptr
	lda spr_glyph_ptr
	sta glyph_draw_ptr
	lda spr_glyph_ptr + 1
	sta glyph_draw_ptr + 1

	; Fetch the control flag bits
	lda #0
	tay
	jsr get_bit
	sta flag_mirror_y

	tya			; A = 0
	jsr get_bit
	sta flag_mirror_x

	; Fetch the segment data index
	tya			; A = 0
	jsr get_bit	; fetch 3 bits
	jsr get_2bits

	; Multiply by 7
	sta tmpbyte
	asl
	asl
	asl
	sec
	sbc tmpbyte	; * 8 - k
	
	sta glyph_offs

	;=========================================================
	; Now, copy glyph segment data
	lda #7
	sta glyph_row

	; Based on control bits ..
	lda flag_mirror_y
	beq dont_mirror_y

	; Mirror horizontally
	; glyph_offs += 6 [0..6]
	lda glyph_offs
	clc
	adc #6
	sta glyph_offs

	lda #$ff	; delta = -1
;	sta glyph_offs_delta
;	jmp sstart
	bne sstart	; Z = 0 always


dont_mirror_y:
	; No mirroring
	lda #1		; delta = 1

sstart:
	sta glyph_offs_delta


	;=========================================================
	; Main copy loop
scopy:
	; Do we mirror horizontally?
	lda flag_mirror_x
	beq dont_mirror_x

	; Mirror horizontally by reversing bits
	ldy glyph_offs
	lda font_segs, y
	sta tmpbyte

	lda #0
	ldx #8

revbits:
	lsr tmpbyte
	rol

	dex
	bne revbits
	beq skip_x

dont_mirror_x:
	; No horizontal mirroring
	ldy glyph_offs
	lda font_segs, y

skip_x:
	ldy #0
	sta (glyph_draw_ptr), y

	; glyph_offs +/- 1
	lda glyph_offs
	clc
	adc glyph_offs_delta
	sta glyph_offs

	; glyph_draw_ptr += 3
	lda glyph_draw_ptr
	clc
	adc #3
	sta glyph_draw_ptr
	bcc nplo
	inc glyph_draw_ptr + 1
nplo:

	; Repeat until seg copied
	dec glyph_row
	bne scopy
	rts


;=========================================================
; Get 2 bits from the font datastream
;=========================================================
get_2bits:
	jsr get_bit

;=========================================================
; Fetch one bit from the datastream, return it in
; A register, changes X register.
; This is done in size-optimized, really wasteful way
; by rol'ing the whole compressed data section to get the
; bits in order ... This also limits max data length to
; 255 bytes, of course.
;=========================================================
get_bit:
	ldx #font_defs_len
bitlp:
	rol font_defs, x
	dex
	bne bitlp
	rol
	rts

;=========================================================
; Data
;=========================================================
font_counter:
	.byte nfont_defs

font_segs:
	.bin 0, 0, "toobig_segs.dat"

font_defs:
	.byte 0
	.bin 0, 0, "toobig_defs.dat"
font_defs_end:
