/*
 * Decompiled with CFR 0.152.
 */
package kickassu.setup;

import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import kickass.asmnode.AsmNode;
import kickass.asmnode.metanodes.AsmNodeList;
import kickass.directives.asmmode.AlignDirective;
import kickass.directives.asmmode.AssertCodeDirective;
import kickass.directives.asmmode.AssertDirective;
import kickass.directives.asmmode.AssertErrorCodeDirective;
import kickass.directives.asmmode.AssertErrorDirective;
import kickass.directives.asmmode.BracketScopeDirective;
import kickass.directives.asmmode.DataBlockDirective;
import kickass.directives.asmmode.DefineDirective;
import kickass.directives.asmmode.EasterEggDirective;
import kickass.directives.asmmode.EncodingDirective;
import kickass.directives.asmmode.EnumDirective;
import kickass.directives.asmmode.ErrorDirective;
import kickass.directives.asmmode.ErrorIfDirective;
import kickass.directives.asmmode.EvalDirective;
import kickass.directives.asmmode.FillDirective;
import kickass.directives.asmmode.ForDirective;
import kickass.directives.asmmode.FunctionDeclarationDirective;
import kickass.directives.asmmode.IfDirective;
import kickass.directives.asmmode.ImportBinaryDirective;
import kickass.directives.asmmode.ImportOnceDirective;
import kickass.directives.asmmode.ImportSourceDirective;
import kickass.directives.asmmode.ImportTextDirective;
import kickass.directives.asmmode.LabelAssignmentDirective;
import kickass.directives.asmmode.LabelDirective;
import kickass.directives.asmmode.MacroDefinition;
import kickass.directives.asmmode.MacroExecution;
import kickass.directives.asmmode.MemoryBlockDirective;
import kickass.directives.asmmode.ModifyDirective;
import kickass.directives.asmmode.MultiLabelDirective;
import kickass.directives.asmmode.NamespaceDirective;
import kickass.directives.asmmode.PluginDirective;
import kickass.directives.asmmode.PrintDirective;
import kickass.directives.asmmode.PrintNowDirective;
import kickass.directives.asmmode.PseudoCommandDefinition;
import kickass.directives.asmmode.PseudoCommandExecution;
import kickass.directives.asmmode.PseudoPCDirective;
import kickass.directives.asmmode.StructDirective;
import kickass.directives.asmmode.TextBlockDirective;
import kickass.expressions.ExprNode;
import kickass.functionnode.AssertFDirective;
import kickass.functionnode.BracketScopeFDirective;
import kickass.functionnode.ErrorFDirective;
import kickass.functionnode.ErrorIfFDirective;
import kickass.functionnode.EvalFDirective;
import kickass.functionnode.ForFDirective;
import kickass.functionnode.FunctionNode;
import kickass.functionnode.FunctionNodeList;
import kickass.functionnode.IfFDirective;
import kickass.functionnode.PrintFDirective;
import kickass.functionnode.PrintNowFDirective;
import kickass.functionnode.ReturnFDirective;
import kickass.libraries.Library;
import kickass.libraries.MathLibrary;
import kickass.libraries.MiscLibrary;
import kickass.libraries.MnemonicsLibrary;
import kickass.libraries.PrintLibrary;
import kickass.libraries.StdConstructorLibrary;
import kickass.libraries.VectorLibrary;
import kickass.state.EvaluationState;
import kickass.state.scope.ExecutableDirectives;
import kickass.statements.ConstDeclaration;
import kickass.statements.StmtNode;
import kickass.statements.VariableDeclaration;
import kickass.tools.tuples.Pair;
import kickass.tools.tuples.Triple;
import kickassu._65xx._65xxArgType;
import kickassu._65xx._65xxMnemonicNode;
import kickassu._65xx._65xxMnemonics;
import kickassu.configuration.parameters.KickAssemblerParameters;
import kickassu.parsing.baselang.BaseLangLexer;
import kickassu.parsing.baselang.tokenstreams.ITokenStream;
import kickassu.parsing.baselang.tokenstreams.PeakTokenStream;
import kickassu.parsing.baselang.tokenstreams.RangeProcessor;
import kickassu.parsing.baselang.tokenstreams.WhiteSpaceSimplifierStream;
import kickassu.parsing.functionparse.FunctionDirectiveParser;
import kickassu.parsing.mainparse.IDirectiveParser;
import kickassu.parsing.mainparse.MainParser;
import kickassu.parsing.mainparse.tailparsers.AssertErrorTailParser;
import kickassu.parsing.mainparse.tailparsers.AssertTailParser;
import kickassu.parsing.mainparse.tailparsers.AssignmentTailParser;
import kickassu.parsing.mainparse.tailparsers.EnumTailParser;
import kickassu.parsing.mainparse.tailparsers.ExprBodyParser;
import kickassu.parsing.mainparse.tailparsers.ExprBodyTailParser;
import kickassu.parsing.mainparse.tailparsers.ExprListTailParser;
import kickassu.parsing.mainparse.tailparsers.FilemodifyTailParser;
import kickassu.parsing.mainparse.tailparsers.ForTailParser;
import kickassu.parsing.mainparse.tailparsers.IdArgsBodyTailParser;
import kickassu.parsing.mainparse.tailparsers.IdArgsexprsBodyTailParser;
import kickassu.parsing.mainparse.tailparsers.IdBodyTailParser;
import kickassu.parsing.mainparse.tailparsers.IdFilebodyTailParser;
import kickassu.parsing.mainparse.tailparsers.IdsBodyTailParser;
import kickassu.parsing.mainparse.tailparsers.IfTailParser;
import kickassu.parsing.mainparse.tailparsers.ImportTailParser;
import kickassu.parsing.mainparse.tailparsers.LabelAssignmentTailParser;
import kickassu.parsing.mainparse.tailparsers.NoArgBodyParser;
import kickassu.parsing.mainparse.tailparsers.ParanExprBodyTailParser;
import kickassu.parsing.mainparse.tailparsers.PcBodyParser;
import kickassu.parsing.mainparse.tailparsers.StmtBodyParser;
import kickassu.parsing.mainparse.tailparsers.StringBodyParser;
import kickassu.parsing.mainparse.tailparsers.StructBodyParser;
import kickassu.parsing.mainparse.tailparsers._65xxMnemonicTailParser;
import kickassu.parsing.mainparse.tailparsers._65xxPseudoCmdDefTailParser;
import kickassu.parsing.mainparse.tailparsers._65xxPseudoCmdTailParser;
import kickassu.parsing.preprocessor.PreProcessor;
import kickassu.parsing.preprocessor.directives.PpdDefine;
import kickassu.parsing.preprocessor.directives.PpdElif;
import kickassu.parsing.preprocessor.directives.PpdElse;
import kickassu.parsing.preprocessor.directives.PpdEndif;
import kickassu.parsing.preprocessor.directives.PpdIf;
import kickassu.parsing.preprocessor.directives.PpdImport;
import kickassu.parsing.preprocessor.directives.PpdImportIf;
import kickassu.parsing.preprocessor.directives.PpdImportOnce;
import kickassu.parsing.preprocessor.directives.PpdUndef;
import kickassu.parsing.sourcelocation.SourceRange;
import kickassu.tools.functions.Func5;

public class KickAssemblerSetup {
    public static List<Library> getStdLibararies() {
        ArrayList<Library> arrayList = new ArrayList<Library>();
        arrayList.add(new MathLibrary());
        arrayList.add(new PrintLibrary());
        arrayList.add(new VectorLibrary());
        arrayList.add(new StdConstructorLibrary());
        arrayList.add(new MiscLibrary());
        arrayList.add(new MnemonicsLibrary());
        return arrayList;
    }

    public static ITokenStream getLexer(String string, Reader reader, EvaluationState evaluationState) {
        ITokenStream iTokenStream = KickAssemblerSetup.createPreprocessor(string, reader, evaluationState);
        iTokenStream = new RangeProcessor(iTokenStream, evaluationState);
        iTokenStream = new PeakTokenStream(iTokenStream);
        return iTokenStream;
    }

    public static PreProcessor createPreprocessor(String string, Reader reader, EvaluationState evaluationState) {
        BaseLangLexer baseLangLexer = new BaseLangLexer(reader);
        baseLangLexer.setFilename(string);
        baseLangLexer.setState(evaluationState);
        WhiteSpaceSimplifierStream whiteSpaceSimplifierStream = new WhiteSpaceSimplifierStream(baseLangLexer);
        PreProcessor preProcessor = new PreProcessor(whiteSpaceSimplifierStream, evaluationState);
        preProcessor.addDirective("#define", new PpdDefine(preProcessor));
        preProcessor.addDirective("#if", new PpdIf(preProcessor));
        preProcessor.addDirective("#else", new PpdElse(preProcessor));
        preProcessor.addDirective("#elif", new PpdElif(preProcessor));
        preProcessor.addDirective("#endif", new PpdEndif(preProcessor));
        preProcessor.addDirective("#undef", new PpdUndef(preProcessor));
        preProcessor.addDirective("#import", new PpdImport(preProcessor));
        preProcessor.addDirective("#importif", new PpdImportIf(preProcessor));
        preProcessor.addDirective("#importonce", new PpdImportOnce(preProcessor));
        return preProcessor;
    }

    public static IDirectiveParser<AsmNode> getMainParser(EvaluationState evaluationState) {
        IDirectiveParser<FunctionNode> iDirectiveParser = KickAssemblerSetup.getFunctionParser(evaluationState);
        KickAssemblerParameters kickAssemblerParameters = evaluationState.getKickAssemblerParams();
        MainParser mainParser = new MainParser();
        MainParser mainParser2 = new MainParser();
        mainParser.setScopeNodeCreator(list -> new AsmNodeList((List<AsmNode>)list));
        mainParser.setMacroExecNodeCreator((string, list, sourceRange) -> new MacroExecution((String)string, (List<ExprNode>)list, (SourceRange)sourceRange));
        mainParser.setPseudoCmdExecNodeCreator(new _65xxPseudoCmdTailParser((string, list, sourceRange) -> new PseudoCommandExecution((String)string, (List<ExprNode>)list, (SourceRange)sourceRange)));
        mainParser.addSubPaser(".filenamespace", new IdFilebodyTailParser<AsmNode>(mainParser, (string, list, sourceRange) -> new NamespaceDirective(new AsmNodeList((List<AsmNode>)list), (String)string, (SourceRange)sourceRange)));
        mainParser.addSubPaser(".importonce", new NoArgBodyParser(sourceRange -> new ImportOnceDirective((SourceRange)sourceRange)));
        mainParser.addSubPaser(".filemodify", new FilemodifyTailParser(mainParser, (string, list, list2, sourceRange) -> new ModifyDirective((String)string, (List<ExprNode>)list, new AsmNodeList((List<AsmNode>)list2), (SourceRange)sourceRange)));
        mainParser.addSubPaser(".easteregg", new NoArgBodyParser(sourceRange -> new EasterEggDirective((SourceRange)sourceRange)));
        mainParser.addSubPaser(".align", new ExprBodyParser<AsmNode>((exprNode, sourceRange) -> new AlignDirective((ExprNode)exprNode, (SourceRange)sourceRange)));
        mainParser.addSubPaser(".encoding", new ExprBodyParser<AsmNode>((exprNode, sourceRange) -> new EncodingDirective((ExprNode)exprNode, (SourceRange)sourceRange)));
        mainParser.addSubPaser(".text", new ExprBodyParser<AsmNode>((exprNode, sourceRange) -> new TextBlockDirective((ExprNode)exprNode, (SourceRange)sourceRange)));
        mainParser.addSubPaser(".te", new ExprBodyParser<AsmNode>((exprNode, sourceRange) -> new TextBlockDirective((ExprNode)exprNode, (SourceRange)sourceRange)));
        mainParser.addSubPaser(".eval", new StmtBodyParser<AsmNode>((stmtNode, sourceRange) -> new EvalDirective((StmtNode)stmtNode, (SourceRange)sourceRange)));
        mainParser.addSubPaser(".error", new ExprBodyParser<AsmNode>((exprNode, sourceRange) -> new ErrorDirective((ExprNode)exprNode, (SourceRange)sourceRange)));
        mainParser.addSubPaser(".errorif", new ExprListTailParser<AsmNode>((list, sourceRange) -> new ErrorIfDirective((List<ExprNode>)list, (SourceRange)sourceRange)));
        mainParser.addSubPaser(".print", new ExprBodyParser<AsmNode>((exprNode, sourceRange) -> new PrintDirective((ExprNode)exprNode, (SourceRange)sourceRange)));
        mainParser.addSubPaser(".printnow", new ExprBodyParser<AsmNode>((exprNode, sourceRange) -> new PrintNowDirective((ExprNode)exprNode, (SourceRange)sourceRange)));
        mainParser.addSubPaser(".pseudopc", new ExprBodyTailParser<AsmNode>(mainParser, (exprNode, list, sourceRange) -> new PseudoPCDirective((ExprNode)exprNode, new AsmNodeList((List<AsmNode>)list), (SourceRange)sourceRange)));
        mainParser.addSubPaser(".namespace", new IdBodyTailParser<AsmNode>(mainParser, (string, list, sourceRange) -> new NamespaceDirective(new AsmNodeList((List<AsmNode>)list), (String)string, (SourceRange)sourceRange)));
        mainParser.addSubPaser(".byte", new ExprListTailParser<AsmNode>((list, sourceRange) -> new DataBlockDirective(1, (List<ExprNode>)list, (SourceRange)sourceRange)));
        mainParser.addSubPaser(".by", new ExprListTailParser<AsmNode>((list, sourceRange) -> new DataBlockDirective(1, (List<ExprNode>)list, (SourceRange)sourceRange)));
        mainParser.addSubPaser(".word", new ExprListTailParser<AsmNode>((list, sourceRange) -> new DataBlockDirective(2, (List<ExprNode>)list, (SourceRange)sourceRange)));
        mainParser.addSubPaser(".wo", new ExprListTailParser<AsmNode>((list, sourceRange) -> new DataBlockDirective(2, (List<ExprNode>)list, (SourceRange)sourceRange)));
        mainParser.addSubPaser(".dword", new ExprListTailParser<AsmNode>((list, sourceRange) -> new DataBlockDirective(4, (List<ExprNode>)list, (SourceRange)sourceRange)));
        mainParser.addSubPaser(".dw", new ExprListTailParser<AsmNode>((list, sourceRange) -> new DataBlockDirective(4, (List<ExprNode>)list, (SourceRange)sourceRange)));
        mainParser.addSubPaser(".fill", new ExprListTailParser<AsmNode>((list, sourceRange) -> new FillDirective((List<ExprNode>)list, (SourceRange)sourceRange)).setFixedNoOfArgs(2));
        mainParser.addSubPaser(".struct", new StructBodyParser((string, list, sourceRange) -> new StructDirective((String)string, (List<String>)list, (SourceRange)sourceRange)));
        mainParser.addSubPaser(".label", new LabelAssignmentTailParser((iToken, iToken2, exprNode, sourceRange) -> new LabelAssignmentDirective(iToken.getStringValue(), (ExprNode)exprNode, iToken.getSourceRange())));
        mainParser.addSubPaser(".const", new AssignmentTailParser<AsmNode>((iToken, iToken2, exprNode, sourceRange) -> new EvalDirective(new ConstDeclaration(iToken.getStringValue(), (ExprNode)exprNode, iToken.getSourceRange()), (SourceRange)sourceRange)));
        mainParser.addSubPaser(".enum", new EnumTailParser((string, list, sourceRange) -> new EnumDirective((List<Triple<String, SourceRange, ExprNode>>)list, (SourceRange)sourceRange)));
        mainParser.addSubPaser(".var", new AssignmentTailParser<AsmNode>((iToken, iToken2, exprNode, sourceRange) -> new EvalDirective(new VariableDeclaration(iToken.getStringValue(), (ExprNode)exprNode, iToken.getSourceRange()), (SourceRange)sourceRange)).setAssignmentIsOptional(true));
        mainParser.addSubPaser(".import", new ImportTailParser().addType("source", (list, sourceRange) -> new ImportSourceDirective((List<ExprNode>)list, (SourceRange)sourceRange)).addType("text", (list, sourceRange) -> new ImportTextDirective((List<ExprNode>)list, (SourceRange)sourceRange)).addType("binary", (list, sourceRange) -> new ImportBinaryDirective(false, (List<ExprNode>)list, (SourceRange)sourceRange)).addType("c64", (list, sourceRange) -> new ImportBinaryDirective(true, (List<ExprNode>)list, (SourceRange)sourceRange)));
        mainParser.addSubPaser(".plugin", new StringBodyParser<AsmNode>((string, sourceRange) -> new PluginDirective((String)string, (SourceRange)sourceRange)));
        mainParser.addSubPaser(".assert", new AssertTailParser<AsmNode>(mainParser2, (exprNode, exprNode2, exprNode3, sourceRange) -> new AssertDirective((ExprNode)exprNode, (ExprNode)exprNode2, (ExprNode)exprNode3, (SourceRange)sourceRange), (exprNode, asmNode, asmNode2, sourceRange) -> new AssertCodeDirective((ExprNode)exprNode, (AsmNode)asmNode, (AsmNode)asmNode2, (SourceRange)sourceRange)));
        mainParser.addSubPaser(".asserterror", new AssertErrorTailParser(mainParser2, (exprNode, exprNode2, sourceRange) -> new AssertErrorDirective((ExprNode)exprNode, (ExprNode)exprNode2, (SourceRange)sourceRange), (exprNode, asmNode, sourceRange) -> new AssertErrorCodeDirective((ExprNode)exprNode, (AsmNode)asmNode, (SourceRange)sourceRange)));
        mainParser.addSubPaser(".define", new IdsBodyTailParser<AsmNode, FunctionNode>(iDirectiveParser, (list, list2, sourceRange) -> new DefineDirective((List<String>)list, new FunctionNodeList((List<FunctionNode>)list2), (SourceRange)sourceRange)));
        mainParser.addSubPaser(".modify", new IdArgsexprsBodyTailParser<AsmNode>(mainParser, (string, list, list2, sourceRange) -> new ModifyDirective((String)string, (List<ExprNode>)list, new AsmNodeList((List<AsmNode>)list2), (SourceRange)sourceRange)));
        mainParser.addSubPaser(".macro", new IdArgsBodyTailParser<AsmNode>(mainParser, (string, list, list2, sourceRange) -> new MacroDefinition((String)string, (List<String>)list, (List<AsmNode>)list2, (SourceRange)sourceRange)));
        mainParser.addSubPaser(".pseudocommand", new _65xxPseudoCmdDefTailParser(mainParser, (string, executableDirectives, sourceRange) -> new PseudoCommandDefinition((String)string, (ExecutableDirectives)executableDirectives, (SourceRange)sourceRange)));
        mainParser.addSubPaser(".function", new IdArgsBodyTailParser<FunctionNode>(iDirectiveParser, (string, list, list2, sourceRange) -> new FunctionDeclarationDirective((String)string, (List<String>)list, (List<FunctionNode>)list2, (SourceRange)sourceRange)));
        mainParser.addSubPaser(".if", new IfTailParser<AsmNode>(mainParser2, (exprNode, asmNode, asmNode2, sourceRange) -> new IfDirective((ExprNode)exprNode, (AsmNode)asmNode, (AsmNode)asmNode2, (SourceRange)sourceRange)));
        mainParser.addSubPaser(".for", new ForTailParser<AsmNode>(mainParser2, (list, exprNode, list2, asmNode, sourceRange) -> new ForDirective((List<StmtNode>)list, (ExprNode)exprNode, (List<ExprNode>)list2, (AsmNode)asmNode, (SourceRange)sourceRange)));
        mainParser.addSubPaser(".while", new ParanExprBodyTailParser<AsmNode>(mainParser, (exprNode, list, sourceRange) -> new ForDirective(StmtNode.emptyList, (ExprNode)exprNode, ExprNode.emptyList, new AsmNodeList((List<AsmNode>)list), (SourceRange)sourceRange)));
        mainParser.addSubPaser(".pc", new PcBodyParser((exprNode, string, bl, sourceRange) -> new MemoryBlockDirective((ExprNode)exprNode, (String)string, (Boolean)bl, (SourceRange)sourceRange)));
        mainParser.setStarParser(new PcBodyParser((exprNode, string, bl, sourceRange) -> new MemoryBlockDirective((ExprNode)exprNode, (String)string, (Boolean)bl, (SourceRange)sourceRange)));
        mainParser.setLabelCreator((string, sourceRange) -> new LabelDirective((String)string, (SourceRange)sourceRange));
        mainParser.setMultiLabelCreator((string, sourceRange) -> new MultiLabelDirective((String)string, (SourceRange)sourceRange));
        ArrayList<Pair<String, int[]>> arrayList = new ArrayList<Pair<String, int[]>>();
        arrayList.addAll(_65xxMnemonics.get65xxMnemonics());
        if (kickAssemblerParameters.dtvMode) {
            arrayList.addAll(_65xxMnemonics.get65xxMnemonics());
        }
        for (Pair pair : arrayList) {
            String string4 = (String)pair.getA();
            int[] nArray = (int[])pair.getB();
            Func5<String, _65xxArgType, ExprNode, String, SourceRange, AsmNode> func5 = (string2, _65xxArgType2, exprNode, string3, sourceRange) -> _65xxMnemonicNode.createNode(string4, string2, _65xxArgType2, exprNode, nArray, string3, sourceRange, evaluationState);
            mainParser.addSubPaser(string4, new _65xxMnemonicTailParser(func5));
        }
        mainParser.copyTo(mainParser2);
        mainParser.setScopeNodeCreator(list -> new BracketScopeDirective(new AsmNodeList((List<AsmNode>)list)));
        return mainParser;
    }

    public static IDirectiveParser<FunctionNode> getFunctionParser(EvaluationState evaluationState) {
        FunctionDirectiveParser functionDirectiveParser = new FunctionDirectiveParser();
        FunctionDirectiveParser functionDirectiveParser2 = new FunctionDirectiveParser();
        functionDirectiveParser.setScopeNodeCreator(list -> new FunctionNodeList((List<FunctionNode>)list));
        functionDirectiveParser.addSubPaser(".eval", new StmtBodyParser<FunctionNode>((stmtNode, sourceRange) -> new EvalFDirective((StmtNode)stmtNode, (SourceRange)sourceRange)));
        functionDirectiveParser.addSubPaser(".error", new ExprBodyParser<FunctionNode>((exprNode, sourceRange) -> new ErrorFDirective((ExprNode)exprNode, (SourceRange)sourceRange)));
        functionDirectiveParser.addSubPaser(".errorif", new ExprListTailParser<FunctionNode>((list, sourceRange) -> new ErrorIfFDirective((List<ExprNode>)list, (SourceRange)sourceRange)));
        functionDirectiveParser.addSubPaser(".print", new ExprBodyParser<FunctionNode>((exprNode, sourceRange) -> new PrintFDirective((ExprNode)exprNode, (SourceRange)sourceRange)));
        functionDirectiveParser.addSubPaser(".printnow", new ExprBodyParser<FunctionNode>((exprNode, sourceRange) -> new PrintNowFDirective((ExprNode)exprNode, (SourceRange)sourceRange)));
        functionDirectiveParser.addSubPaser(".return", new ExprBodyParser<FunctionNode>((exprNode, sourceRange) -> new ReturnFDirective((ExprNode)exprNode, (SourceRange)sourceRange)));
        functionDirectiveParser.addSubPaser(".const", new AssignmentTailParser<FunctionNode>((iToken, iToken2, exprNode, sourceRange) -> new EvalFDirective(new ConstDeclaration(iToken.getStringValue(), (ExprNode)exprNode, iToken.getSourceRange()), (SourceRange)sourceRange)));
        functionDirectiveParser.addSubPaser(".var", new AssignmentTailParser<FunctionNode>((iToken, iToken2, exprNode, sourceRange) -> new EvalFDirective(new VariableDeclaration(iToken.getStringValue(), (ExprNode)exprNode, iToken.getSourceRange()), (SourceRange)sourceRange)).setAssignmentIsOptional(true));
        functionDirectiveParser.addSubPaser(".while", new ParanExprBodyTailParser<FunctionNode>(functionDirectiveParser, (exprNode, list, sourceRange) -> new ForFDirective(StmtNode.emptyList, (ExprNode)exprNode, ExprNode.emptyList, new FunctionNodeList((List<FunctionNode>)list), (SourceRange)sourceRange)));
        functionDirectiveParser.addSubPaser(".if", new IfTailParser<FunctionNode>(functionDirectiveParser2, (exprNode, functionNode, functionNode2, sourceRange) -> new IfFDirective((ExprNode)exprNode, (FunctionNode)functionNode, (FunctionNode)functionNode2, (SourceRange)sourceRange)));
        functionDirectiveParser.addSubPaser(".for", new ForTailParser<FunctionNode>(functionDirectiveParser2, (list, exprNode, list2, functionNode, sourceRange) -> new ForFDirective((List<StmtNode>)list, (ExprNode)exprNode, (List<ExprNode>)list2, (FunctionNode)functionNode, (SourceRange)sourceRange)));
        functionDirectiveParser.addSubPaser(".assert", new AssertTailParser<FunctionNode>(functionDirectiveParser2, (exprNode, exprNode2, exprNode3, sourceRange) -> new AssertFDirective((ExprNode)exprNode, (ExprNode)exprNode2, (ExprNode)exprNode3, (SourceRange)sourceRange), null));
        functionDirectiveParser.copyTo(functionDirectiveParser2);
        functionDirectiveParser.setScopeNodeCreator(list -> new BracketScopeFDirective(new FunctionNodeList((List<FunctionNode>)list)));
        return functionDirectiveParser;
    }
}

