/*
 * Decompiled with CFR 0.152.
 */
package kickassu.parsing.script.symbolstreams;

import java_cup.runtime.Symbol;
import kickassu.parsing.baselang.TokenType;
import kickassu.parsing.baselang.tokens.IToken;

public class TokenToScriptSymbolConverter {
    private static int[] convTable = new int[TokenType.getNoOfTypes()];

    public static Symbol getSymbolValue(IToken iToken) {
        TokenType tokenType = iToken.getType();
        if (tokenType == TokenType.Id) {
            String string = iToken.getStringValue();
            if (string.equals("var")) {
                return new Symbol(46, iToken);
            }
            if (string.equals("const")) {
                return new Symbol(47, iToken);
            }
        }
        return new Symbol(convTable[tokenType.getIdNo()], iToken);
    }

    static {
        for (int i = 0; i < convTable.length; ++i) {
            TokenToScriptSymbolConverter.convTable[i] = 56;
        }
        TokenToScriptSymbolConverter.convTable[TokenType.Id.getIdNo()] = 50;
        TokenToScriptSymbolConverter.convTable[TokenType.LocalLabelId.getIdNo()] = 51;
        TokenToScriptSymbolConverter.convTable[TokenType.Null.getIdNo()] = 54;
        TokenToScriptSymbolConverter.convTable[TokenType.Boolean.getIdNo()] = 49;
        TokenToScriptSymbolConverter.convTable[TokenType.Number.getIdNo()] = 48;
        TokenToScriptSymbolConverter.convTable[TokenType.StringQuote.getIdNo()] = 52;
        TokenToScriptSymbolConverter.convTable[TokenType.CharQuote.getIdNo()] = 53;
        TokenToScriptSymbolConverter.convTable[TokenType.Assign.getIdNo()] = 10;
        TokenToScriptSymbolConverter.convTable[TokenType.Comma.getIdNo()] = 42;
        TokenToScriptSymbolConverter.convTable[TokenType.Semi.getIdNo()] = 43;
        TokenToScriptSymbolConverter.convTable[TokenType.GreaterEqual.getIdNo()] = 29;
        TokenToScriptSymbolConverter.convTable[TokenType.LessEqual.getIdNo()] = 28;
        TokenToScriptSymbolConverter.convTable[TokenType.Greater.getIdNo()] = 16;
        TokenToScriptSymbolConverter.convTable[TokenType.Less.getIdNo()] = 15;
        TokenToScriptSymbolConverter.convTable[TokenType.BitAnd.getIdNo()] = 19;
        TokenToScriptSymbolConverter.convTable[TokenType.BitOr.getIdNo()] = 20;
        TokenToScriptSymbolConverter.convTable[TokenType.BitXor.getIdNo()] = 21;
        TokenToScriptSymbolConverter.convTable[TokenType.ShiftLeft.getIdNo()] = 22;
        TokenToScriptSymbolConverter.convTable[TokenType.ShiftRight.getIdNo()] = 23;
        TokenToScriptSymbolConverter.convTable[TokenType.Plus.getIdNo()] = 11;
        TokenToScriptSymbolConverter.convTable[TokenType.Minus.getIdNo()] = 12;
        TokenToScriptSymbolConverter.convTable[TokenType.Times.getIdNo()] = 13;
        TokenToScriptSymbolConverter.convTable[TokenType.Divide.getIdNo()] = 14;
        TokenToScriptSymbolConverter.convTable[TokenType.NotEqual.getIdNo()] = 25;
        TokenToScriptSymbolConverter.convTable[TokenType.Equal.getIdNo()] = 24;
        TokenToScriptSymbolConverter.convTable[TokenType.And.getIdNo()] = 30;
        TokenToScriptSymbolConverter.convTable[TokenType.Or.getIdNo()] = 31;
        TokenToScriptSymbolConverter.convTable[TokenType.Not.getIdNo()] = 26;
        TokenToScriptSymbolConverter.convTable[TokenType.PlusPlus.getIdNo()] = 34;
        TokenToScriptSymbolConverter.convTable[TokenType.MinusMinus.getIdNo()] = 35;
        TokenToScriptSymbolConverter.convTable[TokenType.PlusEqual.getIdNo()] = 36;
        TokenToScriptSymbolConverter.convTable[TokenType.MinusEqual.getIdNo()] = 37;
        TokenToScriptSymbolConverter.convTable[TokenType.TimesEqual.getIdNo()] = 38;
        TokenToScriptSymbolConverter.convTable[TokenType.DivideEqual.getIdNo()] = 39;
        TokenToScriptSymbolConverter.convTable[TokenType.Dot.getIdNo()] = 27;
        TokenToScriptSymbolConverter.convTable[TokenType.Colon.getIdNo()] = 44;
        TokenToScriptSymbolConverter.convTable[TokenType.Questionmark.getIdNo()] = 45;
        TokenToScriptSymbolConverter.convTable[TokenType.LSBracket.getIdNo()] = 17;
        TokenToScriptSymbolConverter.convTable[TokenType.RSBracket.getIdNo()] = 18;
        TokenToScriptSymbolConverter.convTable[TokenType.LParan.getIdNo()] = 40;
        TokenToScriptSymbolConverter.convTable[TokenType.RParan.getIdNo()] = 41;
        TokenToScriptSymbolConverter.convTable[TokenType.Eos.getIdNo()] = 0;
    }
}

