/*
 * Decompiled with CFR 0.152.
 */
package kickassu.parsing.script;

import java.util.ArrayList;
import java.util.List;
import java_cup.runtime.Symbol;
import kickass.expressions.ExprNode;
import kickass.state.EvaluationState;
import kickass.statements.StmtNode;
import kickassu.exceptions.AsmErrorException;
import kickassu.parsing.baselang.TokenCategory;
import kickassu.parsing.baselang.tokens.IToken;
import kickassu.parsing.baselang.tokens.RangeToken;
import kickassu.parsing.baselang.tokenstreams.TokenStreamList;
import kickassu.parsing.script.ScriptExpressionParser;
import kickassu.parsing.script.symbolstreams.ListSymbolStream;
import kickassu.parsing.script.symbolstreams.TokenToScriptSymbolConverter;

public class ExprParser {
    private static ScriptExpressionParser parser = new ScriptExpressionParser();

    public static ExprNode parse(TokenStreamList tokenStreamList, EvaluationState evaluationState) {
        return (ExprNode)ExprParser.parseX(2, tokenStreamList, tokenStreamList.getIndex(), tokenStreamList.getReverseIndex(), evaluationState);
    }

    public static ExprNode parse(TokenStreamList tokenStreamList, int n, int n2, EvaluationState evaluationState) {
        return (ExprNode)ExprParser.parseX(2, tokenStreamList, n, n2, evaluationState);
    }

    public static StmtNode parseStmt(TokenStreamList tokenStreamList, EvaluationState evaluationState) {
        return (StmtNode)ExprParser.parseX(3, tokenStreamList, tokenStreamList.getIndex(), tokenStreamList.getReverseIndex(), evaluationState);
    }

    public static List<ExprNode> parseOptExprList(TokenStreamList tokenStreamList, EvaluationState evaluationState) {
        return (List)ExprParser.parseX(5, tokenStreamList, tokenStreamList.getIndex(), tokenStreamList.getReverseIndex(), evaluationState);
    }

    public static List<StmtNode> parseOptStmtList(TokenStreamList tokenStreamList, EvaluationState evaluationState) {
        return (List)ExprParser.parseX(7, tokenStreamList, tokenStreamList.getIndex(), tokenStreamList.getReverseIndex(), evaluationState);
    }

    public static List<String> parseOptIdList(TokenStreamList tokenStreamList, EvaluationState evaluationState) {
        return (List)ExprParser.parseX(9, tokenStreamList, tokenStreamList.getIndex(), tokenStreamList.getReverseIndex(), evaluationState);
    }

    private static Object parseX(int n, TokenStreamList tokenStreamList, int n2, int n3, EvaluationState evaluationState) {
        ArrayList<Symbol> arrayList = new ArrayList<Symbol>();
        arrayList.add(new Symbol(n));
        for (int i = n2 + 1; i < n3; ++i) {
            ExprParser.addSymbols(tokenStreamList.get(i), arrayList);
        }
        IToken iToken = tokenStreamList.get(n3);
        if (iToken.isEos()) {
            iToken = tokenStreamList.getTerminatingToken();
        }
        parser.setSymbolStream(new ListSymbolStream(arrayList, iToken));
        parser.setState(evaluationState);
        try {
            return ExprParser.parser.parse().value;
        }
        catch (AsmErrorException asmErrorException) {
            evaluationState.addError(asmErrorException.getError());
            return null;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private static void addSymbols(IToken iToken, List<Symbol> list) {
        TokenCategory tokenCategory = iToken.getType().getCategory();
        if (tokenCategory == TokenCategory.whitespace) {
            return;
        }
        if (tokenCategory == TokenCategory.range) {
            RangeToken rangeToken = (RangeToken)iToken;
            list.add(TokenToScriptSymbolConverter.getSymbolValue(rangeToken.getRangeStartToken()));
            for (IToken iToken2 : rangeToken.getChildren()) {
                ExprParser.addSymbols(iToken2, list);
            }
            list.add(TokenToScriptSymbolConverter.getSymbolValue(rangeToken.getRangeEndToken()));
            return;
        }
        list.add(TokenToScriptSymbolConverter.getSymbolValue(iToken));
    }
}

