/*
 * Decompiled with CFR 0.152.
 */
package kickassu.parsing.preprocessor.directives;

import kickass.state.EvaluationState;
import kickass.state.FileManager;
import kickassu.parsing.baselang.tokens.IToken;
import kickassu.parsing.baselang.tokenstreams.TokenStreamList;
import kickassu.parsing.preprocessor.PreProcessor;
import kickassu.parsing.preprocessor.directives.IPreProcessorDirective;
import kickassu.parsing.preprocessor.directives.PpdUtil;

public class PpdImportOnce
implements IPreProcessorDirective {
    private PreProcessor preprocessor;

    public PpdImportOnce(PreProcessor preProcessor) {
        this.preprocessor = preProcessor;
    }

    @Override
    public void executeDirective(IToken iToken, TokenStreamList tokenStreamList) {
        EvaluationState evaluationState = this.preprocessor.getState();
        if (!PpdUtil.ensureNoOfArguments(iToken, 0, tokenStreamList, evaluationState)) {
            return;
        }
        boolean bl = evaluationState.getPreprocessoreState().isInPassiveState();
        if (bl) {
            return;
        }
        String string = iToken.getSourceRange().getFileName();
        FileManager fileManager = evaluationState.getFileManager();
        fileManager.excludeFileForImport(fileManager.getFile(string, true));
    }
}

