/*
 * Decompiled with CFR 0.152.
 */
package kickassu.parsing.preprocessor.directives;

import java.io.IOException;
import kickass.state.EvaluationState;
import kickassu.errors.AsmError;
import kickassu.parsing.baselang.TokenType;
import kickassu.parsing.baselang.tokens.IToken;
import kickassu.parsing.baselang.tokenstreams.TokenStreamList;
import kickassu.parsing.preprocessor.PreProcessor;
import kickassu.parsing.preprocessor.directives.IPreProcessorDirective;
import kickassu.parsing.preprocessor.directives.PpdUtil;

public class PpdImport
implements IPreProcessorDirective {
    private PreProcessor preprocessor;

    public PpdImport(PreProcessor preProcessor) {
        this.preprocessor = preProcessor;
    }

    @Override
    public void executeDirective(IToken iToken, TokenStreamList tokenStreamList) throws IOException {
        EvaluationState evaluationState = this.preprocessor.getState();
        if (!PpdUtil.ensureNoOfArguments(iToken, 1, tokenStreamList, evaluationState)) {
            return;
        }
        IToken iToken2 = tokenStreamList.get(0);
        if (iToken2.getType() != TokenType.StringQuote) {
            evaluationState.addError(new AsmError("Filename string expected", iToken2.getSourceRange()));
            return;
        }
        boolean bl = evaluationState.getPreprocessoreState().isInPassiveState();
        if (bl) {
            return;
        }
        String string = iToken2.getStringValue();
        this.preprocessor.importFile(string, iToken2.getSourceRange());
    }
}

