/*
 * Decompiled with CFR 0.152.
 */
package kickassu.parsing.preprocessor.directives;

import kickass.state.EvaluationState;
import kickassu.errors.AsmError;
import kickassu.parsing.baselang.tokens.IToken;
import kickassu.parsing.baselang.tokenstreams.TokenStreamList;
import kickassu.parsing.preprocessor.IfState;
import kickassu.parsing.preprocessor.PreProcessor;
import kickassu.parsing.preprocessor.directives.IPreProcessorDirective;
import kickassu.parsing.preprocessor.directives.PpdUtil;
import kickassu.parsing.sourcelocation.SourceRange;

public class PpdElse
implements IPreProcessorDirective {
    private PreProcessor preprocessor;

    public PpdElse(PreProcessor preProcessor) {
        this.preprocessor = preProcessor;
    }

    @Override
    public void executeDirective(IToken iToken, TokenStreamList tokenStreamList) {
        IfState ifState;
        EvaluationState evaluationState = this.preprocessor.getState();
        if (!PpdUtil.ensureNoOfArguments(iToken, 0, tokenStreamList, evaluationState)) {
            return;
        }
        SourceRange sourceRange = iToken.getSourceRange();
        IfState ifState2 = evaluationState.getPreprocessoreState().popState(sourceRange);
        if (ifState2 == null) {
            evaluationState.addError(new AsmError("Else without if", sourceRange));
            return;
        }
        if (ifState2 == IfState.ifTaken) {
            ifState = IfState.elseNotTaken;
        } else if (ifState2 == IfState.ifNotTaken) {
            ifState = IfState.elseTaken;
        } else if (ifState2 == IfState.unevaluatedIf) {
            ifState = IfState.unevaluatedElse;
        } else {
            evaluationState.addError(new AsmError("Else without if", iToken.getSourceRange()));
            return;
        }
        evaluationState.getPreprocessoreState().pushState(ifState, iToken.getSourceRange());
    }
}

