/*
 * Decompiled with CFR 0.152.
 */
package kickassu.parsing.preprocessor.directives;

import kickass.state.EvaluationState;
import kickassu.errors.AsmError;
import kickassu.parsing.baselang.tokens.IToken;
import kickassu.parsing.baselang.tokenstreams.TokenStreamList;
import kickassu.parsing.preprocessor.IfState;
import kickassu.parsing.preprocessor.PreProcessor;
import kickassu.parsing.preprocessor.PreprocessorParser;
import kickassu.parsing.preprocessor.directives.IPreProcessorDirective;
import kickassu.parsing.sourcelocation.SourceRange;

public class PpdElif
implements IPreProcessorDirective {
    private PreProcessor preprocessor;

    public PpdElif(PreProcessor preProcessor) {
        this.preprocessor = preProcessor;
    }

    @Override
    public void executeDirective(IToken iToken, TokenStreamList tokenStreamList) {
        IfState ifState;
        EvaluationState evaluationState = this.preprocessor.getState();
        Boolean bl = PreprocessorParser.parse(tokenStreamList, evaluationState);
        if (bl == null) {
            return;
        }
        SourceRange sourceRange = iToken.getSourceRange();
        IfState ifState2 = evaluationState.getPreprocessoreState().popState(sourceRange);
        if (ifState2 == null) {
            evaluationState.addError(new AsmError("Elif without if", sourceRange));
            return;
        }
        if (ifState2 == IfState.ifTaken) {
            ifState = IfState.ifNotTaken;
        } else if (ifState2 == IfState.ifNotTaken) {
            ifState = bl != false ? IfState.ifTaken : IfState.ifNotTaken;
        } else if (ifState2 == IfState.unevaluatedIf) {
            ifState = IfState.unevaluatedIf;
        } else {
            evaluationState.addError(new AsmError("Elif without if", sourceRange));
            return;
        }
        evaluationState.getPreprocessoreState().pushState(ifState, sourceRange);
    }
}

