/*
 * Decompiled with CFR 0.152.
 */
package kickassu.parsing.preprocessor.directives;

import kickass.state.EvaluationState;
import kickassu.errors.AsmError;
import kickassu.parsing.baselang.TokenType;
import kickassu.parsing.baselang.tokens.IToken;
import kickassu.parsing.baselang.tokenstreams.TokenStreamList;
import kickassu.parsing.preprocessor.PreProcessor;
import kickassu.parsing.preprocessor.directives.IPreProcessorDirective;
import kickassu.parsing.preprocessor.directives.PpdUtil;

public class PpdDefine
implements IPreProcessorDirective {
    private PreProcessor preprocessor;

    public PpdDefine(PreProcessor preProcessor) {
        this.preprocessor = preProcessor;
    }

    @Override
    public void executeDirective(IToken iToken, TokenStreamList tokenStreamList) {
        EvaluationState evaluationState = this.preprocessor.getState();
        if (!PpdUtil.ensureNoOfArguments(iToken, 1, tokenStreamList, evaluationState)) {
            return;
        }
        boolean bl = evaluationState.getPreprocessoreState().isInPassiveState();
        if (bl) {
            return;
        }
        IToken iToken2 = tokenStreamList.get(0);
        if (iToken2.getType() != TokenType.Id) {
            evaluationState.addError(new AsmError("symbolname must be an identifer", iToken2.getSourceRange()));
            return;
        }
        String string = (String)iToken2.getValue();
        evaluationState.getPreprocessoreState().getDefinedSymbols().add(string);
    }
}

