/*
 * Decompiled with CFR 0.152.
 */
package kickassu.parsing.preprocessor;

import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import kickass.state.EvaluationState;
import kickassu.parsing.preprocessor.IfEntry;
import kickassu.parsing.preprocessor.IfState;
import kickassu.parsing.sourcelocation.SourceRange;
import kickassu.parsing.syntaxinfo.SyntaxInfo;
import kickassu.parsing.syntaxinfo.SyntaxType;

public class PreprocessorState {
    private Stack<IfEntry> ifStack = new Stack();
    private Set<String> definedSymbols = new HashSet<String>();
    private EvaluationState state;

    public PreprocessorState(EvaluationState evaluationState) {
        this.state = evaluationState;
    }

    public Set<String> getDefinedSymbols() {
        return this.definedSymbols;
    }

    public IfState popState(SourceRange sourceRange) {
        int n;
        int n2;
        boolean bl;
        if (this.ifStack.isEmpty()) {
            return null;
        }
        IfEntry ifEntry = this.ifStack.pop();
        IfState ifState = ifEntry.getState();
        boolean bl2 = bl = ifState.isPassiveState() && !this.isInPassiveState();
        if (bl && (n2 = ifEntry.getDirectiveRange().getStartLineNo() + 1) < (n = sourceRange.getStartLineNo())) {
            SourceRange sourceRange2 = new SourceRange(n2, 0, n, 0, sourceRange.getFileName());
            this.state.addSyntaxInfo(new SyntaxInfo(SyntaxType.ppDisabledCode, sourceRange2));
        }
        return ifState;
    }

    public void pushState(IfState ifState, SourceRange sourceRange) {
        this.ifStack.push(new IfEntry(ifState, sourceRange));
    }

    public boolean isInPassiveState() {
        if (this.ifStack.isEmpty()) {
            return false;
        }
        return this.ifStack.peek().getState().isPassiveState();
    }
}

