/*
 * Decompiled with CFR 0.152.
 */
package kickassu.parsing.mainparse.tailparsers;

import java.io.IOException;
import java.util.List;
import kickass.asmnode.AsmNode;
import kickass.state.EvaluationState;
import kickassu.parsing.baselang.TokenType;
import kickassu.parsing.baselang.tokens.IToken;
import kickassu.parsing.baselang.tokenstreams.ITokenStream;
import kickassu.parsing.mainparse.tailparsers.ITailParser;
import kickassu.parsing.script.ExprParser;
import kickassu.parsing.sourcelocation.SourceRange;
import kickassu.tools.functions.Func3;

public class StructBodyParser
implements ITailParser<AsmNode> {
    private Func3<String, List<String>, SourceRange, AsmNode> nodeCreator;

    public StructBodyParser(Func3<String, List<String>, SourceRange, AsmNode> func3) {
        this.nodeCreator = func3;
    }

    @Override
    public AsmNode parse(IToken iToken, SourceRange sourceRange, ITokenStream iTokenStream, EvaluationState evaluationState) throws IOException {
        iTokenStream.skipWsAndNl();
        IToken iToken2 = iTokenStream.expectTypeSkipWs(TokenType.Id, evaluationState);
        if (iToken2 == null) {
            return null;
        }
        String string = iToken2.getValue().toString();
        iTokenStream.skipWsAndNl();
        IToken iToken3 = iTokenStream.expectTypeSkipWs(TokenType.CurlyBracketRange, evaluationState);
        if (iToken3 == null) {
            return null;
        }
        List<String> list = ExprParser.parseOptIdList(iToken3.getChildStream(), evaluationState);
        if (list == null) {
            return null;
        }
        return this.nodeCreator.apply(string, list, sourceRange);
    }
}

