/*
 * Decompiled with CFR 0.152.
 */
package kickassu.parsing.mainparse.tailparsers;

import java.io.IOException;
import kickass.asmnode.AsmNode;
import kickass.expressions.ExprNode;
import kickass.state.EvaluationState;
import kickassu.parsing.baselang.TokenType;
import kickassu.parsing.baselang.tokens.IToken;
import kickassu.parsing.baselang.tokenstreams.ITokenStream;
import kickassu.parsing.baselang.tokenstreams.TokenStreamList;
import kickassu.parsing.mainparse.tailparsers.ITailParser;
import kickassu.parsing.script.ExprParser;
import kickassu.parsing.sourcelocation.SourceRange;
import kickassu.tools.functions.Func4;

public class PcBodyParser
implements ITailParser<AsmNode> {
    private Func4<ExprNode, String, Boolean, SourceRange, AsmNode> nodeCreator;

    public PcBodyParser(Func4<ExprNode, String, Boolean, SourceRange, AsmNode> func4) {
        this.nodeCreator = func4;
    }

    @Override
    public AsmNode parse(IToken iToken, SourceRange sourceRange, ITokenStream iTokenStream, EvaluationState evaluationState) throws IOException {
        TokenStreamList tokenStreamList = iTokenStream.getUntilSemiOrNlSkipWs();
        if (iToken.getType() != TokenType.TimesEqual && tokenStreamList.expectType(TokenType.Assign, evaluationState) == null) {
            return null;
        }
        boolean bl = false;
        int n = tokenStreamList.getReverseIndex();
        IToken iToken2 = tokenStreamList.reverseNext();
        if (iToken2.isId("virtual")) {
            bl = true;
            n = tokenStreamList.getReverseIndex();
        }
        tokenStreamList.setReverseIndexs(n);
        String string = null;
        IToken iToken3 = tokenStreamList.reverseNext();
        if (iToken3.getType() == TokenType.StringQuote) {
            string = iToken3.getStringValue();
            n = tokenStreamList.getReverseIndex();
        }
        tokenStreamList.setReverseIndexs(n);
        ExprNode exprNode = ExprParser.parse(tokenStreamList, evaluationState);
        if (exprNode == null) {
            return null;
        }
        return this.nodeCreator.apply(exprNode, string, bl, sourceRange);
    }
}

