/*
 * Decompiled with CFR 0.152.
 */
package kickassu.parsing.mainparse.tailparsers;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import kickass.asmnode.AsmNode;
import kickass.expressions.ExprNode;
import kickass.state.EvaluationState;
import kickassu.errors.AsmError;
import kickassu.parsing.baselang.TokenType;
import kickassu.parsing.baselang.tokens.IToken;
import kickassu.parsing.baselang.tokenstreams.ITokenStream;
import kickassu.parsing.baselang.tokenstreams.TokenStreamList;
import kickassu.parsing.mainparse.tailparsers.ITailParser;
import kickassu.parsing.script.ExprParser;
import kickassu.parsing.sourcelocation.SourceRange;

public class ImportTailParser
implements ITailParser<AsmNode> {
    private Map<String, BiFunction<List<ExprNode>, SourceRange, AsmNode>> nodeCreatorMap = new HashMap<String, BiFunction<List<ExprNode>, SourceRange, AsmNode>>();

    public ImportTailParser addType(String string, BiFunction<List<ExprNode>, SourceRange, AsmNode> biFunction) {
        this.nodeCreatorMap.put(string, biFunction);
        return this;
    }

    @Override
    public AsmNode parse(IToken iToken, SourceRange sourceRange, ITokenStream iTokenStream, EvaluationState evaluationState) throws IOException {
        TokenStreamList tokenStreamList = iTokenStream.getUntilSemiOrNlSkipWs();
        IToken iToken2 = tokenStreamList.expectType(TokenType.Id, evaluationState);
        if (iToken2 == null) {
            return null;
        }
        String string = iToken2.getStringValue();
        BiFunction<List<ExprNode>, SourceRange, AsmNode> biFunction = this.nodeCreatorMap.get(string);
        if (biFunction == null) {
            evaluationState.addError(new AsmError("Invalid argument", iToken2.getSourceRange()));
            return null;
        }
        List<ExprNode> list = ExprParser.parseOptExprList(tokenStreamList, evaluationState);
        if (list == null) {
            return null;
        }
        return biFunction.apply(list, sourceRange);
    }
}

