/*
 * Decompiled with CFR 0.152.
 */
package kickassu.parsing.mainparse.tailparsers;

import java.io.IOException;
import kickass.expressions.ExprNode;
import kickass.state.EvaluationState;
import kickassu.errors.AsmError;
import kickassu.parsing.baselang.TokenType;
import kickassu.parsing.baselang.tokens.IToken;
import kickassu.parsing.baselang.tokenstreams.ITokenStream;
import kickassu.parsing.mainparse.IDirectiveParser;
import kickassu.parsing.mainparse.tailparsers.ITailParser;
import kickassu.parsing.script.ExprParser;
import kickassu.parsing.sourcelocation.SourceRange;
import kickassu.tools.functions.Func4;

public class IfTailParser<NODE>
implements ITailParser<NODE> {
    private IDirectiveParser<NODE> subParser;
    private Func4<ExprNode, NODE, NODE, SourceRange, NODE> nodeCreator;

    public IfTailParser(IDirectiveParser<NODE> iDirectiveParser, Func4<ExprNode, NODE, NODE, SourceRange, NODE> func4) {
        this.nodeCreator = func4;
        this.subParser = iDirectiveParser;
    }

    @Override
    public NODE parse(IToken iToken, SourceRange sourceRange, ITokenStream iTokenStream, EvaluationState evaluationState) throws IOException {
        IToken iToken2 = iTokenStream.expectTypeSkipWs(TokenType.ParanthesisRange, evaluationState);
        if (iToken2 == null) {
            return null;
        }
        ExprNode exprNode = ExprParser.parse(iToken2.getChildStream(), evaluationState);
        NODE NODE = this.subParser.parse(iTokenStream, evaluationState);
        if (NODE == null) {
            evaluationState.getErrors().add(new AsmError("If without body", sourceRange));
            return null;
        }
        Object T3 = null;
        iTokenStream.skipWsAndNl();
        boolean bl = iTokenStream.peek().isId("else");
        if (bl) {
            iTokenStream.next();
            T3 = this.subParser.parse(iTokenStream, evaluationState);
            if (T3 == null) {
                evaluationState.getErrors().add(new AsmError("Else without body", sourceRange));
                return null;
            }
        }
        return this.nodeCreator.apply(exprNode, NODE, T3, sourceRange);
    }
}

