/*
 * Decompiled with CFR 0.152.
 */
package kickassu.parsing.mainparse.tailparsers;

import java.io.IOException;
import java.util.List;
import kickass.expressions.ExprNode;
import kickass.state.EvaluationState;
import kickass.statements.StmtNode;
import kickassu.errors.AsmError;
import kickassu.parsing.baselang.TokenType;
import kickassu.parsing.baselang.tokens.IToken;
import kickassu.parsing.baselang.tokenstreams.ITokenStream;
import kickassu.parsing.baselang.tokenstreams.TokenStreamList;
import kickassu.parsing.mainparse.IDirectiveParser;
import kickassu.parsing.mainparse.tailparsers.ITailParser;
import kickassu.parsing.script.ExprParser;
import kickassu.parsing.sourcelocation.SourceRange;
import kickassu.tools.functions.Func5;

public class ForTailParser<NODE>
implements ITailParser<NODE> {
    private IDirectiveParser<NODE> subParser;
    private Func5<List<StmtNode>, ExprNode, List<ExprNode>, NODE, SourceRange, NODE> nodeCreator;

    public ForTailParser(IDirectiveParser<NODE> iDirectiveParser, Func5<List<StmtNode>, ExprNode, List<ExprNode>, NODE, SourceRange, NODE> func5) {
        this.nodeCreator = func5;
        this.subParser = iDirectiveParser;
    }

    @Override
    public NODE parse(IToken iToken, SourceRange sourceRange, ITokenStream iTokenStream, EvaluationState evaluationState) throws IOException {
        IToken iToken2 = iTokenStream.expectTypeSkipWs(TokenType.ParanthesisRange, evaluationState);
        if (iToken2 == null) {
            return null;
        }
        NODE NODE = this.subParser.parse(iTokenStream, evaluationState);
        if (NODE == null) {
            evaluationState.getErrors().add(new AsmError("Directive missing body", sourceRange));
            return null;
        }
        TokenStreamList tokenStreamList = iToken2.getChildStream();
        TokenStreamList tokenStreamList2 = tokenStreamList.getUntilSemiSkipWsAndNl();
        if (tokenStreamList2.getTerminatingToken().getType() != TokenType.Semi) {
            SourceRange sourceRange2 = tokenStreamList2.getTerminatingToken().getSourceRange();
            evaluationState.getErrors().add(new AsmError("Expected ;", sourceRange2));
            return null;
        }
        List<StmtNode> list = ExprParser.parseOptStmtList(tokenStreamList2, evaluationState);
        TokenStreamList tokenStreamList3 = tokenStreamList.getUntilSemiSkipWsAndNl();
        if (tokenStreamList3.getTerminatingToken().getType() != TokenType.Semi) {
            SourceRange sourceRange3 = tokenStreamList3.getTerminatingToken().getSourceRange();
            evaluationState.getErrors().add(new AsmError("Expected ;", sourceRange3));
            return null;
        }
        ExprNode exprNode = ExprParser.parse(tokenStreamList3, evaluationState);
        List<ExprNode> list2 = ExprParser.parseOptExprList(tokenStreamList, evaluationState);
        if (list == null || exprNode == null || list2 == null) {
            return null;
        }
        return this.nodeCreator.apply(list, exprNode, list2, NODE, sourceRange);
    }
}

