/*
 * Decompiled with CFR 0.152.
 */
package kickassu.parsing.mainparse.tailparsers;

import java.io.IOException;
import java.util.List;
import java.util.function.BiFunction;
import kickass.expressions.ExprNode;
import kickass.state.EvaluationState;
import kickassu.errors.AsmError;
import kickassu.parsing.baselang.tokens.IToken;
import kickassu.parsing.baselang.tokenstreams.ITokenStream;
import kickassu.parsing.baselang.tokenstreams.TokenStreamList;
import kickassu.parsing.mainparse.tailparsers.ITailParser;
import kickassu.parsing.script.ExprParser;
import kickassu.parsing.sourcelocation.SourceRange;

public class ExprListTailParser<NODE>
implements ITailParser<NODE> {
    private Integer fixedNoOfArgs = null;
    private BiFunction<List<ExprNode>, SourceRange, NODE> nodeCreator;

    public ExprListTailParser(BiFunction<List<ExprNode>, SourceRange, NODE> biFunction) {
        this.nodeCreator = biFunction;
    }

    public ExprListTailParser<NODE> setFixedNoOfArgs(Integer n) {
        this.fixedNoOfArgs = n;
        return this;
    }

    @Override
    public NODE parse(IToken iToken, SourceRange sourceRange, ITokenStream iTokenStream, EvaluationState evaluationState) throws IOException {
        boolean bl;
        TokenStreamList tokenStreamList = iTokenStream.getUntilSemiOrNlSkipWs();
        List<ExprNode> list = ExprParser.parseOptExprList(tokenStreamList, evaluationState);
        if (list == null) {
            return null;
        }
        boolean bl2 = bl = this.fixedNoOfArgs != null && list.size() != this.fixedNoOfArgs.intValue();
        if (bl) {
            evaluationState.addError(new AsmError("Invalid number of arguments.", sourceRange));
            return null;
        }
        return this.nodeCreator.apply(list, sourceRange);
    }
}

