/*
 * Decompiled with CFR 0.152.
 */
package kickassu.parsing.mainparse.tailparsers;

import java.io.IOException;
import java.util.List;
import kickass.expressions.ExprNode;
import kickass.state.EvaluationState;
import kickassu.parsing.baselang.TokenType;
import kickassu.parsing.baselang.tokens.IToken;
import kickassu.parsing.baselang.tokenstreams.ITokenStream;
import kickassu.parsing.baselang.tokenstreams.TokenStreamList;
import kickassu.parsing.mainparse.IDirectiveParser;
import kickassu.parsing.mainparse.tailparsers.ITailParser;
import kickassu.parsing.script.ExprParser;
import kickassu.parsing.sourcelocation.SourceRange;
import kickassu.tools.functions.Func3;

public class ExprBodyTailParser<NODE>
implements ITailParser<NODE> {
    private IDirectiveParser<NODE> subParser;
    private Func3<ExprNode, List<NODE>, SourceRange, NODE> nodeCreator;

    public ExprBodyTailParser(IDirectiveParser<NODE> iDirectiveParser, Func3<ExprNode, List<NODE>, SourceRange, NODE> func3) {
        this.subParser = iDirectiveParser;
        this.nodeCreator = func3;
    }

    @Override
    public NODE parse(IToken iToken, SourceRange sourceRange, ITokenStream iTokenStream, EvaluationState evaluationState) throws IOException {
        TokenStreamList tokenStreamList = iTokenStream.getUntilSemiOrNlOrCurly();
        ExprNode exprNode = ExprParser.parse(tokenStreamList, evaluationState);
        if (exprNode == null) {
            return null;
        }
        IToken iToken2 = tokenStreamList.getTerminatingToken();
        if (iToken2.getType() != TokenType.CurlyBracketRange && (iToken2 = iTokenStream.expectTypeSkipWsAndNl(TokenType.CurlyBracketRange, evaluationState)) == null) {
            return null;
        }
        List<NODE> list = this.subParser.parseAll(iToken2.getChildStream(), evaluationState);
        return this.nodeCreator.apply(exprNode, list, sourceRange);
    }
}

