/*
 * Decompiled with CFR 0.152.
 */
package kickassu.parsing.mainparse.tailparsers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import kickass.asmnode.AsmNode;
import kickass.expressions.ExprNode;
import kickass.state.EvaluationState;
import kickass.tools.tuples.Triple;
import kickassu.parsing.baselang.TokenType;
import kickassu.parsing.baselang.tokens.IToken;
import kickassu.parsing.baselang.tokenstreams.ITokenStream;
import kickassu.parsing.baselang.tokenstreams.TokenStreamList;
import kickassu.parsing.mainparse.tailparsers.ITailParser;
import kickassu.parsing.script.ExprParser;
import kickassu.parsing.sourcelocation.SourceRange;
import kickassu.tools.functions.Func3;

public class EnumTailParser
implements ITailParser<AsmNode> {
    private Func3<String, List<Triple<String, SourceRange, ExprNode>>, SourceRange, AsmNode> nodeCreator;

    public EnumTailParser(Func3<String, List<Triple<String, SourceRange, ExprNode>>, SourceRange, AsmNode> func3) {
        this.nodeCreator = func3;
    }

    @Override
    public AsmNode parse(IToken iToken, SourceRange sourceRange, ITokenStream iTokenStream, EvaluationState evaluationState) throws IOException {
        Object T1 = null;
        iTokenStream.skipWsAndNl();
        IToken iToken2 = iTokenStream.expectType(TokenType.CurlyBracketRange, evaluationState);
        if (iToken2 == null) {
            return null;
        }
        ArrayList<Triple<String, SourceRange, Object>> arrayList = new ArrayList<Triple<String, SourceRange, Object>>();
        TokenStreamList tokenStreamList = iToken2.getChildStream();
        while (!tokenStreamList.peek().isEos()) {
            ExprNode exprNode;
            TokenStreamList tokenStreamList2 = tokenStreamList.getUntilCommaSkipWsAndNl();
            IToken iToken3 = tokenStreamList2.expectType(TokenType.Id, evaluationState);
            if (iToken3 == null) continue;
            String string = iToken3.getStringValue();
            SourceRange sourceRange2 = iToken3.getSourceRange();
            IToken iToken4 = tokenStreamList2.next();
            if (iToken4.isEos()) {
                arrayList.add(new Triple<String, SourceRange, Object>(string, sourceRange2, null));
                continue;
            }
            if (!iToken4.expectType(TokenType.Assign, evaluationState, "Invalid token") || (exprNode = ExprParser.parse(tokenStreamList2, evaluationState)) == null) continue;
            arrayList.add(new Triple<String, SourceRange, ExprNode>(string, sourceRange2, exprNode));
        }
        return this.nodeCreator.apply((String)T1, (List<Triple<String, SourceRange, ExprNode>>)arrayList, sourceRange);
    }
}

