/*
 * Decompiled with CFR 0.152.
 */
package kickassu.parsing.mainparse.tailparsers;

import java.io.IOException;
import kickass.expressions.ExprNode;
import kickass.state.EvaluationState;
import kickassu.parsing.baselang.TokenType;
import kickassu.parsing.baselang.tokens.IToken;
import kickassu.parsing.baselang.tokenstreams.ITokenStream;
import kickassu.parsing.baselang.tokenstreams.TokenStreamList;
import kickassu.parsing.mainparse.tailparsers.ITailParser;
import kickassu.parsing.script.ExprParser;
import kickassu.parsing.sourcelocation.SourceRange;
import kickassu.tools.functions.Func4;

public class AssignmentTailParser<T>
implements ITailParser<T> {
    private Func4<IToken, IToken, ExprNode, SourceRange, T> nodeCreator;
    private boolean assignmentIsOptional = false;

    public AssignmentTailParser(Func4<IToken, IToken, ExprNode, SourceRange, T> func4) {
        this.nodeCreator = func4;
    }

    public AssignmentTailParser<T> setAssignmentIsOptional(boolean bl) {
        this.assignmentIsOptional = bl;
        return this;
    }

    @Override
    public T parse(IToken iToken, SourceRange sourceRange, ITokenStream iTokenStream, EvaluationState evaluationState) throws IOException {
        TokenStreamList tokenStreamList = iTokenStream.getUntilSemiOrNlSkipWs();
        IToken iToken2 = tokenStreamList.expectTypeSkipWs(TokenType.Id, evaluationState);
        if (iToken2 == null) {
            return null;
        }
        if (this.assignmentIsOptional && tokenStreamList.peek().isEos()) {
            return this.nodeCreator.apply(iToken2, null, null, sourceRange);
        }
        IToken iToken3 = tokenStreamList.expectType(TokenType.Assign, evaluationState);
        if (iToken3 == null) {
            return null;
        }
        ExprNode exprNode = ExprParser.parse(tokenStreamList, evaluationState);
        if (exprNode == null) {
            return null;
        }
        return this.nodeCreator.apply(iToken2, iToken3, exprNode, sourceRange);
    }
}

