/*
 * Decompiled with CFR 0.152.
 */
package kickassu.parsing.mainparse.tailparsers;

import java.io.IOException;
import kickass.expressions.ExprNode;
import kickass.state.EvaluationState;
import kickassu.errors.AsmError;
import kickassu.parsing.baselang.TokenType;
import kickassu.parsing.baselang.tokens.IToken;
import kickassu.parsing.baselang.tokenstreams.ITokenStream;
import kickassu.parsing.baselang.tokenstreams.TokenStreamList;
import kickassu.parsing.mainparse.IDirectiveParser;
import kickassu.parsing.mainparse.tailparsers.ITailParser;
import kickassu.parsing.script.ExprParser;
import kickassu.parsing.sourcelocation.SourceRange;
import kickassu.tools.functions.Func4;

public class AssertTailParser<NODE>
implements ITailParser<NODE> {
    private IDirectiveParser<NODE> subParser;
    private Func4<ExprNode, ExprNode, ExprNode, SourceRange, NODE> exprAssertNodeCreator;
    private Func4<ExprNode, NODE, NODE, SourceRange, NODE> codeAssertNodeCreator;

    public AssertTailParser(IDirectiveParser<NODE> iDirectiveParser, Func4<ExprNode, ExprNode, ExprNode, SourceRange, NODE> func4, Func4<ExprNode, NODE, NODE, SourceRange, NODE> func42) {
        this.subParser = iDirectiveParser;
        this.exprAssertNodeCreator = func4;
        this.codeAssertNodeCreator = func42;
    }

    @Override
    public NODE parse(IToken iToken, SourceRange sourceRange, ITokenStream iTokenStream, EvaluationState evaluationState) throws IOException {
        boolean bl;
        TokenStreamList tokenStreamList = iTokenStream.getUntilCommaSkipWsAndNl();
        if (tokenStreamList.getTerminatingToken().isEos()) {
            evaluationState.addError(new AsmError("Missing second argument", sourceRange));
            return null;
        }
        ExprNode exprNode = ExprParser.parse(tokenStreamList, evaluationState);
        if (exprNode == null) {
            return null;
        }
        TokenStreamList tokenStreamList2 = iTokenStream.getUntilCommaSkipWsAndNl();
        if (tokenStreamList2.getTerminatingToken().isEos()) {
            evaluationState.addError(new AsmError("Missing third argument", sourceRange));
            return null;
        }
        tokenStreamList2.skipWsAndNl();
        IToken iToken2 = tokenStreamList2.peek();
        boolean bl2 = bl = this.codeAssertNodeCreator != null && iToken2.getType() == TokenType.CurlyBracketRange;
        if (!bl) {
            ExprNode exprNode2 = ExprParser.parse(tokenStreamList2, evaluationState);
            TokenStreamList tokenStreamList3 = iTokenStream.getUntilSemiOrNlSkipWs();
            ExprNode exprNode3 = ExprParser.parse(tokenStreamList3, evaluationState);
            if (exprNode2 == null || tokenStreamList2 == null) {
                return null;
            }
            return this.exprAssertNodeCreator.apply(exprNode, exprNode2, exprNode3, sourceRange);
        }
        NODE NODE = this.subParser.parse(tokenStreamList2, evaluationState);
        iTokenStream.skipWsAndNl();
        IToken iToken3 = iTokenStream.peek();
        if (iToken3.getType() != TokenType.CurlyBracketRange) {
            evaluationState.addError(new AsmError("Invalide expected arg", sourceRange));
            return null;
        }
        NODE NODE2 = this.subParser.parse(iTokenStream, evaluationState);
        if (NODE == null || NODE2 == null) {
            return null;
        }
        return this.codeAssertNodeCreator.apply(exprNode, NODE, NODE2, sourceRange);
    }
}

