/*
 * Decompiled with CFR 0.152.
 */
package kickassu.parsing.mainparse.tailparsers;

import java.io.IOException;
import kickass.asmnode.AsmNode;
import kickass.expressions.ExprNode;
import kickass.state.EvaluationState;
import kickassu.errors.AsmError;
import kickassu.parsing.baselang.TokenType;
import kickassu.parsing.baselang.tokens.IToken;
import kickassu.parsing.baselang.tokenstreams.ITokenStream;
import kickassu.parsing.baselang.tokenstreams.TokenStreamList;
import kickassu.parsing.mainparse.IDirectiveParser;
import kickassu.parsing.mainparse.tailparsers.ITailParser;
import kickassu.parsing.script.ExprParser;
import kickassu.parsing.sourcelocation.SourceRange;
import kickassu.tools.functions.Func3;

public class AssertErrorTailParser
implements ITailParser<AsmNode> {
    private IDirectiveParser<AsmNode> subParser;
    private Func3<ExprNode, ExprNode, SourceRange, AsmNode> exprAssertNodeCreator;
    private Func3<ExprNode, AsmNode, SourceRange, AsmNode> codeAssertNodeCreator;

    public AssertErrorTailParser(IDirectiveParser<AsmNode> iDirectiveParser, Func3<ExprNode, ExprNode, SourceRange, AsmNode> func3, Func3<ExprNode, AsmNode, SourceRange, AsmNode> func32) {
        this.subParser = iDirectiveParser;
        this.exprAssertNodeCreator = func3;
        this.codeAssertNodeCreator = func32;
    }

    @Override
    public AsmNode parse(IToken iToken, SourceRange sourceRange, ITokenStream iTokenStream, EvaluationState evaluationState) throws IOException {
        boolean bl;
        TokenStreamList tokenStreamList = iTokenStream.getUntilCommaSkipWsAndNl();
        if (tokenStreamList.getTerminatingToken().isEos()) {
            evaluationState.addError(new AsmError("Missing second argument", iToken.getSourceRange()));
            return null;
        }
        ExprNode exprNode = ExprParser.parse(tokenStreamList, evaluationState);
        if (exprNode == null) {
            return null;
        }
        iTokenStream.skipWsAndNl();
        IToken iToken2 = iTokenStream.peek();
        boolean bl2 = bl = iToken2.getType() == TokenType.CurlyBracketRange;
        if (bl) {
            AsmNode asmNode = this.subParser.parse(iTokenStream, evaluationState);
            if (asmNode == null) {
                return null;
            }
            return this.codeAssertNodeCreator.apply(exprNode, asmNode, sourceRange);
        }
        ExprNode exprNode2 = ExprParser.parse(iTokenStream.getUntilSemiOrNlSkipWs(), evaluationState);
        if (exprNode2 == null) {
            return null;
        }
        return this.exprAssertNodeCreator.apply(exprNode, exprNode2, sourceRange);
    }
}

