/*
 * Decompiled with CFR 0.152.
 */
package kickassu.parsing.functionparse;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import kickass.functionnode.FunctionNode;
import kickass.state.EvaluationState;
import kickassu.errors.AsmError;
import kickassu.parsing.baselang.TokenType;
import kickassu.parsing.baselang.tokens.IToken;
import kickassu.parsing.baselang.tokenstreams.ITokenStream;
import kickassu.parsing.mainparse.IDirectiveParser;
import kickassu.parsing.mainparse.tailparsers.ITailParser;
import kickassu.parsing.sourcelocation.SourceRange;
import kickassu.parsing.syntaxinfo.SyntaxInfo;
import kickassu.parsing.syntaxinfo.SyntaxType;

public class FunctionDirectiveParser
implements IDirectiveParser<FunctionNode> {
    private Map<String, ITailParser<FunctionNode>> subParsers = new HashMap<String, ITailParser<FunctionNode>>();
    private Function<List<FunctionNode>, FunctionNode> scopeNodeCreator;

    public void copyTo(FunctionDirectiveParser functionDirectiveParser) {
        functionDirectiveParser.subParsers.putAll(this.subParsers);
        functionDirectiveParser.scopeNodeCreator = this.scopeNodeCreator;
    }

    public void setScopeNodeCreator(Function<List<FunctionNode>, FunctionNode> function) {
        this.scopeNodeCreator = function;
    }

    public void addSubPaser(String string, ITailParser<FunctionNode> iTailParser) {
        this.subParsers.put(string, iTailParser);
    }

    @Override
    public FunctionNode parse(ITokenStream iTokenStream, EvaluationState evaluationState) throws IOException {
        boolean bl;
        boolean bl2;
        IToken iToken = iTokenStream.nextSkipWsAndNl();
        if (iToken.isEos()) {
            return null;
        }
        TokenType tokenType = iToken.getType();
        TokenType tokenType2 = iTokenStream.peek().getType();
        boolean bl3 = bl2 = tokenType == TokenType.Dot && tokenType2 == TokenType.Id;
        if (bl2) {
            IToken iToken2 = iTokenStream.next();
            SourceRange sourceRange = new SourceRange(iToken.getSourceRange(), iToken2.getSourceRange());
            evaluationState.addSyntaxInfo(new SyntaxInfo(SyntaxType.directive, sourceRange));
            ITailParser<FunctionNode> iTailParser = this.subParsers.get("." + iToken2.getStringValue());
            if (iTailParser == null) {
                evaluationState.addError(new AsmError("Invalid directive", sourceRange));
                iTokenStream.getUntilSemiOrNl();
                return null;
            }
            return iTailParser.parse(iToken2, sourceRange, iTokenStream, evaluationState);
        }
        boolean bl4 = bl = tokenType == TokenType.CurlyBracketRange;
        if (bl) {
            List<FunctionNode> list = this.parseAll(iToken.getChildStream(), evaluationState);
            return this.scopeNodeCreator.apply(list);
        }
        if (tokenType == TokenType.Semi) {
            return null;
        }
        evaluationState.addError(new AsmError("Invalid token", iToken.getSourceRange()));
        iTokenStream.getUntilSemiOrNl();
        return null;
    }

    @Override
    public List<FunctionNode> parseAll(ITokenStream iTokenStream, EvaluationState evaluationState) throws IOException {
        ArrayList<FunctionNode> arrayList = new ArrayList<FunctionNode>();
        while (!iTokenStream.peek().isEos()) {
            FunctionNode functionNode = this.parse(iTokenStream, evaluationState);
            if (functionNode == null) continue;
            arrayList.add(functionNode);
        }
        return arrayList;
    }
}

