/*
 * Decompiled with CFR 0.152.
 */
package kickassu.parsing.baselang.tokenstreams;

import java.io.IOException;
import kickass.state.EvaluationState;
import kickassu.errors.AsmError;
import kickassu.parsing.baselang.TokenCategory;
import kickassu.parsing.baselang.tokens.IToken;
import kickassu.parsing.baselang.tokens.RangeToken;
import kickassu.parsing.baselang.tokenstreams.ITokenStream;

public class RangeProcessor
implements ITokenStream {
    private ITokenStream stream;
    private EvaluationState state;

    public RangeProcessor(ITokenStream iTokenStream, EvaluationState evaluationState) {
        this.stream = iTokenStream;
        this.state = evaluationState;
    }

    @Override
    public IToken getTerminatingToken() {
        return this.stream.getTerminatingToken();
    }

    @Override
    public IToken next() throws IOException {
        IToken iToken;
        while (true) {
            TokenCategory tokenCategory;
            if ((tokenCategory = (iToken = this.stream.next()).getType().getCategory()) == TokenCategory.rangeStartOperator) {
                RangeToken rangeToken = new RangeToken(iToken.getType().getRangeType(), iToken.getSourceRange());
                rangeToken.setRangeStartToken(iToken);
                this.parseRange(rangeToken);
                return rangeToken;
            }
            if (tokenCategory != TokenCategory.rangeEndOperator) break;
            this.state.addError(new AsmError("Missing start token", iToken.getSourceRange()));
        }
        return iToken;
    }

    private void parseRange(RangeToken rangeToken) throws IOException {
        while (true) {
            IToken iToken;
            if ((iToken = this.stream.next()).isEos()) {
                this.state.addError(new AsmError("Missing end token", rangeToken.getRangeStartToken().getSourceRange()));
                rangeToken.setRangeEndToken(iToken);
                return;
            }
            TokenCategory tokenCategory = iToken.getType().getCategory();
            if (tokenCategory == TokenCategory.rangeStartOperator) {
                RangeToken rangeToken2 = new RangeToken(iToken.getType().getRangeType(), iToken.getSourceRange());
                rangeToken2.setRangeStartToken(iToken);
                rangeToken.addChild(rangeToken2);
                this.parseRange(rangeToken2);
                continue;
            }
            if (tokenCategory == TokenCategory.rangeEndOperator) {
                boolean bl;
                boolean bl2 = bl = rangeToken.getType().getRangeType() != iToken.getType().getRangeType();
                if (bl) {
                    this.state.addError(new AsmError("Missing start token", iToken.getSourceRange()));
                    continue;
                }
                rangeToken.setRangeEndToken(iToken);
                return;
            }
            rangeToken.addChild(iToken);
        }
    }
}

