/*
 * Decompiled with CFR 0.152.
 */
package kickassu.parsing.baselang.tokenstreams;

import java.io.IOException;
import kickassu.parsing.baselang.TokenCategory;
import kickassu.parsing.baselang.TokenType;
import kickassu.parsing.baselang.tokens.IToken;
import kickassu.parsing.baselang.tokenstreams.ITokenStream;

public class PeakTokenStream
implements ITokenStream {
    private ITokenStream stream;
    private boolean isInitialized = false;
    private IToken nextToken1;
    private IToken nextToken2;

    public PeakTokenStream(ITokenStream iTokenStream) {
        this.stream = iTokenStream;
    }

    @Override
    public IToken getTerminatingToken() {
        return this.stream.getTerminatingToken();
    }

    @Override
    public IToken next() throws IOException {
        if (!this.isInitialized) {
            this.nextToken1 = this.stream.next();
            this.nextToken2 = this.stream.next();
            this.isInitialized = true;
        }
        IToken iToken = this.nextToken1;
        this.nextToken1 = this.nextToken2;
        this.nextToken2 = this.stream.next();
        return iToken;
    }

    @Override
    public IToken peek() throws IOException {
        if (!this.isInitialized) {
            this.nextToken1 = this.stream.next();
            this.nextToken2 = this.stream.next();
            this.isInitialized = true;
        }
        return this.nextToken1;
    }

    @Override
    public IToken peekSkipWs() {
        return this.nextToken1.getType() == TokenType.StdWhitespace ? this.nextToken2 : this.nextToken1;
    }

    @Override
    public IToken peekSkipWsAndNl() {
        return this.nextToken1.getType().getCategory() == TokenCategory.whitespace ? this.nextToken2 : this.nextToken1;
    }
}

