/*
 * Decompiled with CFR 0.152.
 */
package kickassu.parsing.baselang.tokenstreams;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import kickass.state.EvaluationState;
import kickassu.errors.AsmError;
import kickassu.parsing.baselang.TokenCategory;
import kickassu.parsing.baselang.TokenType;
import kickassu.parsing.baselang.tokens.IToken;
import kickassu.parsing.baselang.tokenstreams.TokenStreamList;

public interface ITokenStream {
    public IToken next() throws IOException;

    public IToken getTerminatingToken();

    default public void skipWs() throws IOException {
        while (this.peek().getType() == TokenType.StdWhitespace) {
            this.next();
        }
    }

    default public IToken nextSkipWs() throws IOException {
        IToken iToken = this.next();
        while (iToken.getType() == TokenType.StdWhitespace) {
            iToken = this.next();
        }
        return iToken;
    }

    default public void skipWsAndNl() throws IOException {
        while (this.peek().getType().getCategory() == TokenCategory.whitespace) {
            this.next();
        }
    }

    default public IToken nextSkipWsAndNl() throws IOException {
        IToken iToken = this.next();
        while (iToken.getType().getCategory() == TokenCategory.whitespace) {
            iToken = this.next();
        }
        return iToken;
    }

    default public IToken peek() throws IOException {
        throw new RuntimeException("Peak not implemented. No peeking!");
    }

    default public IToken peekSkipWs() throws IOException {
        throw new RuntimeException("Peak not implemented. No peeking!");
    }

    default public IToken peekSkipWsAndNl() throws IOException {
        throw new RuntimeException("Peak not implemented. No peeking!");
    }

    default public List<IToken> toList() throws IOException {
        IToken iToken;
        ArrayList<IToken> arrayList = new ArrayList<IToken>();
        while (!(iToken = this.next()).isEos()) {
            arrayList.add(iToken);
        }
        return arrayList;
    }

    default public List<IToken> toListSkipWs() throws IOException {
        IToken iToken;
        ArrayList<IToken> arrayList = new ArrayList<IToken>();
        while (!(iToken = this.nextSkipWs()).isEos()) {
            arrayList.add(iToken);
        }
        return arrayList;
    }

    default public TokenStreamList getUntilNl() throws IOException {
        ArrayList<IToken> arrayList = new ArrayList<IToken>();
        while (true) {
            IToken iToken = this.next();
            TokenType tokenType = iToken.getType();
            if (iToken.isEos() || tokenType == TokenType.Newline) {
                return new TokenStreamList(arrayList, iToken);
            }
            arrayList.add(iToken);
        }
    }

    default public TokenStreamList getUntilNlSkipWs() throws IOException {
        ArrayList<IToken> arrayList = new ArrayList<IToken>();
        while (true) {
            IToken iToken = this.nextSkipWs();
            TokenType tokenType = iToken.getType();
            if (iToken.isEos() || tokenType == TokenType.Newline) {
                return new TokenStreamList(arrayList, iToken);
            }
            arrayList.add(iToken);
        }
    }

    default public TokenStreamList getUntilSemiOrNl() throws IOException {
        ArrayList<IToken> arrayList = new ArrayList<IToken>();
        while (true) {
            IToken iToken = this.next();
            TokenType tokenType = iToken.getType();
            if (iToken.isEos() || tokenType == TokenType.Newline || tokenType == TokenType.Semi) {
                return new TokenStreamList(arrayList, iToken);
            }
            arrayList.add(iToken);
        }
    }

    default public TokenStreamList getUntilSemiOrNlOrCurly() throws IOException {
        ArrayList<IToken> arrayList = new ArrayList<IToken>();
        while (true) {
            IToken iToken = this.next();
            TokenType tokenType = iToken.getType();
            if (iToken.isEos() || tokenType == TokenType.Newline || tokenType == TokenType.Semi || tokenType == TokenType.CurlyBracketRange) {
                return new TokenStreamList(arrayList, iToken);
            }
            arrayList.add(iToken);
        }
    }

    default public TokenStreamList getUntilCommaSkipWsAndNl() throws IOException {
        ArrayList<IToken> arrayList = new ArrayList<IToken>();
        while (true) {
            IToken iToken = this.nextSkipWsAndNl();
            TokenType tokenType = iToken.getType();
            if (iToken.isEos() || tokenType == TokenType.Comma) {
                return new TokenStreamList(arrayList, iToken);
            }
            arrayList.add(iToken);
        }
    }

    default public TokenStreamList getUntilSemiSkipWsAndNl() throws IOException {
        ArrayList<IToken> arrayList = new ArrayList<IToken>();
        while (true) {
            IToken iToken;
            TokenType tokenType;
            if ((tokenType = (iToken = this.next()).getType()).getCategory() == TokenCategory.whitespace) {
                continue;
            }
            if (iToken.isEos() || tokenType == TokenType.Semi) {
                return new TokenStreamList(arrayList, iToken);
            }
            arrayList.add(iToken);
        }
    }

    default public TokenStreamList getUntilSemiOrNlSkipWs() throws IOException {
        ArrayList<IToken> arrayList = new ArrayList<IToken>();
        while (true) {
            IToken iToken;
            TokenType tokenType;
            if ((tokenType = (iToken = this.next()).getType()) == TokenType.StdWhitespace) {
                continue;
            }
            if (iToken.isEos() || tokenType == TokenType.Newline || tokenType == TokenType.Semi) {
                return new TokenStreamList(arrayList, iToken);
            }
            arrayList.add(iToken);
        }
    }

    default public TokenStreamList getUntilSemiNlOrCurlySkipWs() throws IOException {
        ArrayList<IToken> arrayList = new ArrayList<IToken>();
        while (this.peek().getType() != TokenType.CurlyBracketRange) {
            IToken iToken = this.next();
            TokenType tokenType = iToken.getType();
            if (tokenType == TokenType.StdWhitespace) continue;
            if (iToken.isEos() || tokenType == TokenType.Newline || tokenType == TokenType.Semi) {
                return new TokenStreamList(arrayList, iToken);
            }
            arrayList.add(iToken);
        }
        return new TokenStreamList(arrayList, this.peek());
    }

    default public TokenStreamList getUntilType(TokenType tokenType) throws IOException {
        ArrayList<IToken> arrayList = new ArrayList<IToken>();
        IToken iToken;
        while (!(iToken = this.next()).isEos() && iToken.getType() != tokenType) {
            arrayList.add(iToken);
        }
        return new TokenStreamList(arrayList, iToken);
    }

    default public TokenStreamList getUntilType(TokenType tokenType, TokenType tokenType2) throws IOException {
        ArrayList<IToken> arrayList = new ArrayList<IToken>();
        while (true) {
            IToken iToken = this.next();
            TokenType tokenType3 = iToken.getType();
            if (iToken.isEos() || tokenType3 == tokenType || tokenType3 == tokenType2) {
                return new TokenStreamList(arrayList, iToken);
            }
            arrayList.add(iToken);
        }
    }

    default public IToken expectType(TokenType tokenType, EvaluationState evaluationState) throws IOException {
        IToken iToken = this.next();
        if (iToken.getType() == tokenType) {
            return iToken;
        }
        this.addUnexpectedTokenError(iToken, evaluationState);
        return null;
    }

    default public IToken expectTypeSkipWs(TokenType tokenType, EvaluationState evaluationState) throws IOException {
        IToken iToken = this.nextSkipWs();
        if (iToken.getType() == tokenType) {
            return iToken;
        }
        this.addUnexpectedTokenError(iToken, evaluationState);
        return null;
    }

    default public IToken expectTypeSkipWsAndNl(TokenType tokenType, EvaluationState evaluationState) throws IOException {
        IToken iToken = this.nextSkipWsAndNl();
        if (iToken.getType() == tokenType) {
            return iToken;
        }
        this.addUnexpectedTokenError(iToken, evaluationState);
        return null;
    }

    default public IToken expectIdSkipWs(String string, EvaluationState evaluationState) throws IOException {
        IToken iToken = this.nextSkipWs();
        if (iToken.getType() == TokenType.Id && iToken.getValue().equals(string)) {
            return iToken;
        }
        this.addUnexpectedTokenError(iToken, evaluationState);
        return null;
    }

    default public IToken expectIdSkipWsAndNl(String string, EvaluationState evaluationState) throws IOException {
        IToken iToken = this.nextSkipWsAndNl();
        if (iToken.isId(string)) {
            return iToken;
        }
        this.addUnexpectedTokenError(iToken, evaluationState);
        return null;
    }

    default public void addUnexpectedTokenError(IToken iToken, EvaluationState evaluationState) {
        if (iToken.isEos()) {
            iToken = this.getTerminatingToken();
        }
        if (iToken.isEos()) {
            evaluationState.addError(new AsmError("Unexpected end of source", iToken.getSourceRange()));
        } else if (iToken.getType() == TokenType.Newline) {
            evaluationState.addError(new AsmError("Unexpected end of line", iToken.getSourceRange()));
        } else {
            evaluationState.addError(new AsmError("Invalid token", iToken.getSourceRange()));
        }
    }
}

