/*
 * Decompiled with CFR 0.152.
 */
package kickassu.features;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kickassu.features.Feature;
import kickassu.features.FeatureType;
import kickassu.features.IFeature;

public class KickAssemblerFeatures {
    private static List<IFeature> features = new ArrayList<IFeature>();

    private static void addOption(String string, String string2, String string3) {
        features.add(new Feature(string, FeatureType.option, string2, string3));
    }

    private static void addPreprocessor(String string, String string2, String string3) {
        features.add(new Feature(string, FeatureType.preprocessorDirective, string2, string3));
    }

    private static void addDirective(String string, String string2, String string3) {
        features.add(new Feature(string, FeatureType.directive, string2, string3));
    }

    private static void addValue(String string, String string2, String string3) {
        features.add(new Feature(string, FeatureType.value, string2, string3));
    }

    public static List<IFeature> getAllFeatures() {
        return features;
    }

    public static List<IFeature> getFeaturesOfType(FeatureType featureType) {
        Stream<IFeature> stream = features.stream().filter(iFeature -> iFeature.getType() == featureType);
        return stream.collect(Collectors.toList());
    }

    static {
        KickAssemblerFeatures.addOption("-o", "-o dots.prg", "Sets the output file. Default is the input filename with a \u2018.prg\u2019 as suffix.");
        KickAssemblerFeatures.addOption("-libdir", "-libdir ../stdLib", "Defines a library path where the assembler will look when it tries to open external files.");
        KickAssemblerFeatures.addOption("-showmem", "-showmem", "Show a memory map after assembling.");
        KickAssemblerFeatures.addOption("-execute", "-execute \"x64 +sound\"", "Execute a given program with the assembled file as argument. You can use this to start a C64 emulator with the assembled program if the assembling is successful.");
        KickAssemblerFeatures.addOption("-warningsoff", "-warningsoff", "Turns off warning messages.");
        KickAssemblerFeatures.addOption("-log", "-log logfile.txt", "Prints the output of the assembler to a logfile.");
        KickAssemblerFeatures.addOption("-dtv", "-dtv", "Enables DTV opcodes.");
        KickAssemblerFeatures.addOption("-aom", "-aom", "Allow overlapping memory blocks. With this option, overlapping memory blocks will produce a warning instead of an error.");
        KickAssemblerFeatures.addOption("-time", "-time", "Displays the assemble time.");
        KickAssemblerFeatures.addOption("-vicesymbols", "-vicesymbols", "Generates a label file for VICE.");
        KickAssemblerFeatures.addOption("-binfile", "-binfile", "Sets the output to be a bin file instead of a prg file. The difference between a bin and a prg file is that the bin file doesn\u2019t contain the two start address bytes.");
        KickAssemblerFeatures.addOption("-afo", "-afo", "Allows file output to user defined files.");
        KickAssemblerFeatures.addOption(":name=", ":x=34 :version=beta2 :path=\"c:/C 64/\"", "The \u2018:\u2019 notation denotes string variables passed to the script. They can be accessed by using the \u2018cmdLineVars\u2019 hashtable which is available from the script.");
        KickAssemblerFeatures.addOption("-symbolfile", "-symbolfile", "Genrates a .sym file with the resolved symbols. The file can be used in other sources with the .import source directive.");
        KickAssemblerFeatures.addOption("-symbolfiledir", "-symbolfiledir sources/symbolfiles", "Specifies the folder in which the symbolfile is written. If none is given, its written next to the sourcefile.");
        KickAssemblerFeatures.addOption("-fillbyte", "-fillbyte 255", "Sets the byte used to fill the space between memoryblocks in the prg file.");
        KickAssemblerFeatures.addOption("-maxaddr", "-maxaddr 8191", "Sets the upper limit for the memory, default is 65535. Setting a negative value means unlimited memory.");
        KickAssemblerFeatures.addOption("-mbfiles", "-mbfiles", "One file will be saved for each memory block instead of one big file.");
        KickAssemblerFeatures.addOption("-cfgfile", "-cfgfile \"../../MyConfig.Cfg\"", "Use additional configuration file (like KickAss.cfg). Supply the file as an absolute path, or a path relative to the source file. You can have as many additional config files as you want.");
        KickAssemblerFeatures.addOption("-define", "-define DEBUG", "Defines a preprocessor symbol.");
        KickAssemblerFeatures.addOption("-pseudoc3x", "-pseudoc3x", "Enables semicolon between pseudocommand arguments.");
        KickAssemblerFeatures.addOption("-noeval", "-noeval", "Parse the sourcecode but exit before evaluation.");
        KickAssemblerFeatures.addOption("-asminfo", "-asminfo all", "Turn on exporting of assemble info");
        KickAssemblerFeatures.addOption("-asminfofile", "-asminfofile myAsmInfo.txt", "Tells where to output the asminfo file.");
        KickAssemblerFeatures.addOption("-replacefile", "-replacefile c:\\source.asm c:\\replacement.asm", "Replaces a given sourcefile with another everytime it's referred.");
        KickAssemblerFeatures.addOption("-debug", "-debug", "For development use. Adds additional debug info, like stacktraces, to the output.");
        KickAssemblerFeatures.addOption("-bytedump", "-bytebump", "Dumps the assembled bytes in the file ByteDump.txt together with the code that generated them.");
        KickAssemblerFeatures.addOption("-bytedumpfile", "-bytebumpfile myfile.txt", "Same as -bytedump but with an argument specifying the name of the file");
        KickAssemblerFeatures.addPreprocessor("#define", "#define DEBUG", "Defines a preprocessor symbol.");
        KickAssemblerFeatures.addPreprocessor("#undef", "#undef DEBUG", "Removes the definition of a preprocessor symbol.");
        KickAssemblerFeatures.addPreprocessor("#if", "#if !DEBUG", "Discards the sourcecode after the #if-directive if the condition is false.");
        KickAssemblerFeatures.addPreprocessor("#elif", "#elif TEST", "The combination of an #else and an #if preprocessor directive.");
        KickAssemblerFeatures.addPreprocessor("#else", "#else", "Used after an #if to start an else block which is executed if the condition is false.");
        KickAssemblerFeatures.addPreprocessor("#endif", "#endif", "Marks the end of an #if/#else block.");
        KickAssemblerFeatures.addPreprocessor("#import", "#import \"file2.asm\"", "Imports another sourcefile.");
        KickAssemblerFeatures.addPreprocessor("#importonce", "#importonce", "Make the assembler skip the current file if it has already been imported.");
        KickAssemblerFeatures.addPreprocessor("#importif", "#importif !DEBUG \"file2.asm\"", "Imports another sourcefile if the given expression is evaluated to true.");
        KickAssemblerFeatures.addDirective(".align", ".align $100", "Aligns the memory position with the given value. Ex. '.align $100' at memory position $1234 will set the position to $1300.");
        KickAssemblerFeatures.addDirective(".text", ".text \"hello\"", "Dumps text bytes to memory.");
        KickAssemblerFeatures.addDirective(".te", ".te \"hello\"", "An alias for '.text'.");
        KickAssemblerFeatures.addDirective(".eval", ".eval x=x+y/2", "Evaluates a script expression.");
        KickAssemblerFeatures.addDirective(".error", ".error \"not good!\"", "Creates an user raised error.");
        KickAssemblerFeatures.addDirective(".errorif", ".errorif x>10 \"not good!\"", "Creates an user raised error if condition is evaluated to true.");
        KickAssemblerFeatures.addDirective(".print", ".print \"Hello\"", "Prints a message to the console in the last pass.");
        KickAssemblerFeatures.addDirective(".printnow", ".printnow \"Hello now\"", "Prints a message to the console immediately.");
        KickAssemblerFeatures.addDirective(".pseudopc", ".pseudopc $2000 {...}", "Sets the program counter to something else than the actual memory position.");
        KickAssemblerFeatures.addDirective(".return", ".return 27", "Used inside functions to return a value.");
        KickAssemblerFeatures.addDirective(".namespace", ".namespace myspace {..}", "Creates a local namespace.");
        KickAssemblerFeatures.addDirective(".filenamespace", ".filenamespace myspace", "Creates a namespace for all the following directives in the current source file.");
        KickAssemblerFeatures.addDirective(".byte", ".byte $01,$02,$03", "Outputs bytes.");
        KickAssemblerFeatures.addDirective(".by", ".by $01,$02,$03", "An alias for '.byte'.");
        KickAssemblerFeatures.addDirective(".word", ".word $1000,$1012", "Outputs words (two bytes values),");
        KickAssemblerFeatures.addDirective(".wo", ".wo $1000,$1012", "An alias for '.word'.");
        KickAssemblerFeatures.addDirective(".dword", ".dword $12341234", "Outputs doublewords (4 byte values).");
        KickAssemblerFeatures.addDirective(".dw", ".dw $12341234", "An alias for '.dword'.");
        KickAssemblerFeatures.addDirective(".fill", ".fill 10, i*2", "Fills a number of bytes with the value of a given expression.");
        KickAssemblerFeatures.addDirective(".struct", ".struct Point {x,y}", "Creates a user defined structure.");
        KickAssemblerFeatures.addDirective(".label", ".label color=$d020", "Assigns a given expression to a label.");
        KickAssemblerFeatures.addDirective(".const", ".const DELAY=7", "Defines a constant.");
        KickAssemblerFeatures.addDirective(".enum", ".enum {on, off}", "Defines a series of constants.");
        KickAssemblerFeatures.addDirective(".var", ".var x=27", "Defines a variable.");
        KickAssemblerFeatures.addDirective(".import source", ".import source \"MyLib.asm\"", "Imports another source file. (Depricated, use #import instead)");
        KickAssemblerFeatures.addDirective(".import binary", ".import binary \"Music.bin\"", "Imports a binary file.");
        KickAssemblerFeatures.addDirective(".import c64", ".import c64 \"Music.c64\"", "Imports a c64 files. Same as '.import binary', but ignores the two address bytes at the start of the file.");
        KickAssemblerFeatures.addDirective(".import text", ".import text \"scroll.txt\"", "Imports a text file.");
        KickAssemblerFeatures.addDirective(".importonce", ".importonce", "Make the assembler skip the current file if it has already been imported. (Depricated, use #importonce instead)");
        KickAssemblerFeatures.addDirective(".plugin", ".plugin \"plugins.macros.MyMacro\"", "Tells the assembler to look for a plugin at the given java-package path.");
        KickAssemblerFeatures.addDirective(".assert", ".assert \"Test 1\",2+2,4", "Asserts that two expressions or codeblocks are equal.");
        KickAssemblerFeatures.addDirective(".asserterror", ".asserterror \"Test 2\", List().get(27)", "Asserts that a given expression or codeblock generates an error.");
        KickAssemblerFeatures.addDirective(".define", ".define width, height {...}", "Executes a block of directives in 'functionmode' (faster) to define values.");
        KickAssemblerFeatures.addDirective(".modify", ".modify Encrypt(27) {...}", "Modifies the output of a codeblock using the given modifier.");
        KickAssemblerFeatures.addDirective(".filemodify", ".filemodify Encrypt(33)", "Modify the output of the current source file with the given modifier.");
        KickAssemblerFeatures.addDirective(".macro", ".macro BasicUpstart() {...}", "Defines a macro.");
        KickAssemblerFeatures.addDirective(".pseudocommand", ".pseudocommand mov src:tar {...}", "Defines a pseudocommand.");
        KickAssemblerFeatures.addDirective(".function", ".function area(h,w) {..}", "Defines a function.");
        KickAssemblerFeatures.addDirective(".if", ".if(x>10) {...}", "Executes code if the given condition is true.");
        KickAssemblerFeatures.addDirective(".for", ".for(var i;i<10;i++) {...}", "Creates a for loop.");
        KickAssemblerFeatures.addDirective(".while", ".while(i<10) {...}", "Creates a while loop.");
        KickAssemblerFeatures.addDirective("*", "*=$1000", "Sets the memory position to a given value.");
        KickAssemblerFeatures.addDirective(".pc", ".pc=$1000", "Same as '*='");
        KickAssemblerFeatures.addDirective(".encoding", ".encoding \"screencode_upper\"", "Sets the character encoding.");
        KickAssemblerFeatures.addValue("65xxArgument", "($10),y", "A value that defines an argument given to a mnemnonic.");
        KickAssemblerFeatures.addValue("BinaryFile", "LoadBinary(\"file.bin\", \"\")", "A value containing byte data.");
        KickAssemblerFeatures.addValue("Boolean", "true", "Either true or false.");
        KickAssemblerFeatures.addValue("Null", "null", "A null value.");
        KickAssemblerFeatures.addValue("Number", "27.4", "A floating point number.");
        KickAssemblerFeatures.addValue("Char", "'x'", "A character.");
        KickAssemblerFeatures.addValue("OutputFile", "createFile(\"breakpoints.txt\") ", "An value representing an output file.");
        KickAssemblerFeatures.addValue("Picture", "LoadPicture(\"blob.gif\")", "The contents of a loaded picture.");
        KickAssemblerFeatures.addValue("SidFile", "LoadSid(\"music.sid\")", "The contents of a sid file.");
        KickAssemblerFeatures.addValue("String", "\"Hello\"", "A string value.");
        KickAssemblerFeatures.addValue("Vector", "Vector(1,2,3)", "A 3d vector value.");
        KickAssemblerFeatures.addValue("Hashtable", "Hashtable()", "A value representing a hashtable.");
        KickAssemblerFeatures.addValue("List", "List()", "A list value.");
        KickAssemblerFeatures.addValue("Matrix", "Matrix()", "Represents a 4x4 matrix.");
        KickAssemblerFeatures.addValue("Struct", "MyStruct(1,2)", "Represents a user defined structure.");
        Comparator comparator = (iFeature, iFeature2) -> {
            int n = iFeature.getType().compareTo(iFeature2.getType());
            if (n != 0) {
                return n;
            }
            return iFeature.getName().compareTo(iFeature2.getName());
        };
        Collections.sort(features, comparator);
    }
}

