/*
 * Decompiled with CFR 0.152.
 */
package kickassu.configuration.optionparser;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import kickass.log.Log;
import kickass.state.EvaluationState;
import kickassu.configuration.optionparser.KickAssemblerConfigFileUtil;
import kickassu.exceptions.AsmErrorException;

public class KickAssemblerPluginConfigParser {
    private static Log log = new Log("");

    public static void parsePluginFile(String string, EvaluationState evaluationState) {
        File file = KickAssemblerConfigFileUtil.openConfigFile(string);
        if (file == null) {
            return;
        }
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.startsWith("//")) continue;
                Object object = KickAssemblerPluginConfigParser.createObjectOrNull(string2);
                if (object == null) {
                    log.println("Error while parsing " + string + ". Coundn't find class or create object for pluging: " + string2);
                    continue;
                }
                evaluationState.addPlugin(object);
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            throw new AsmErrorException("Error while reading config file (" + string + "): " + iOException.getMessage());
        }
    }

    private static Object createObjectOrNull(String string) {
        try {
            return Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            return null;
        }
    }
}

