/*
 * Decompiled with CFR 0.152.
 */
package kickassu.assmbleinfo;

import java.util.List;
import kickass.constant.Constant;
import kickass.function.Function;
import kickass.libraries.Library;
import kickass.state.EvaluationState;
import kickassu.assmbleinfo.AssembleInfoType;
import kickassu.assmbleinfo.AssembleInfoTypePool;
import kickassu.assmbleinfo.IAssembleInfoWriter;
import kickassu.errors.AsmError;
import kickassu.features.FeatureType;
import kickassu.features.IFeature;
import kickassu.features.KickAssemblerFeatures;
import kickassu.parsing.syntaxinfo.SyntaxInfo;
import kickassu.setup.KickAssemblerSetup;

public class AssembleInfoManager {
    private IAssembleInfoWriter out;

    public AssembleInfoManager(IAssembleInfoWriter iAssembleInfoWriter) {
        this.out = iAssembleInfoWriter;
    }

    public void WriteInfo(EvaluationState evaluationState) {
        AssembleInfoTypePool assembleInfoTypePool = evaluationState.getKickAssemblerParams().assembleInfos;
        if (assembleInfoTypePool.includes(AssembleInfoType.libraries)) {
            this.writeLibraries(evaluationState);
        }
        if (assembleInfoTypePool.includes(AssembleInfoType.directives)) {
            this.writeFeatures("directives", FeatureType.directive, evaluationState);
        }
        if (assembleInfoTypePool.includes(AssembleInfoType.preprocessorDirectives)) {
            this.writeFeatures("ppdirectives", FeatureType.preprocessorDirective, evaluationState);
        }
        if (assembleInfoTypePool.includes(AssembleInfoType.errors)) {
            this.writeErrors(evaluationState);
        }
        if (assembleInfoTypePool.includes(AssembleInfoType.syntax)) {
            this.writeSyntax(evaluationState);
        }
        if (assembleInfoTypePool.includes(AssembleInfoType.files)) {
            this.out.writeFilesSection("files");
        }
    }

    private void writeSyntax(EvaluationState evaluationState) {
        this.out.addSection("syntax");
        for (SyntaxInfo syntaxInfo : evaluationState.getSyntaxInfo()) {
            this.out.addStringField(syntaxInfo.getType().toString());
            this.out.addSourceRangeField(syntaxInfo.getRange());
            this.out.nextLine();
        }
    }

    private void writeLibraries(EvaluationState evaluationState) {
        this.out.addSection("libraries");
        List<Library> list = KickAssemblerSetup.getStdLibararies();
        for (Library library : list) {
            for (Constant constant : library.getConstants()) {
                this.out.addStringField(library.getName());
                this.out.addStringField("constant");
                this.out.addStringField(constant.getName());
                this.out.nextLine();
            }
            for (Function function : library.getFunctions()) {
                this.out.addStringField(library.getName());
                this.out.addStringField("function");
                this.out.addStringField(function.getName());
                this.out.addIntField(function.getNoOfArguments());
                this.out.nextLine();
            }
        }
    }

    private void writeFeatures(String string, FeatureType featureType, EvaluationState evaluationState) {
        this.out.addSection(string);
        List<IFeature> list = KickAssemblerFeatures.getFeaturesOfType(featureType);
        for (IFeature iFeature : list) {
            this.out.addStringField(iFeature.getName());
            this.out.addStringField(iFeature.getExample());
            this.out.addStringField(iFeature.getDescription());
            this.out.nextLine();
        }
    }

    private void writeErrors(EvaluationState evaluationState) {
        this.out.addSection("errors");
        for (AsmError asmError : evaluationState.getErrors()) {
            this.out.addStringField("Error");
            this.out.addSourceRangeField(asmError.getRange());
            this.out.addStringField(asmError.getMessage());
            this.out.nextLine();
        }
    }
}

