/*
 * Decompiled with CFR 0.152.
 */
package kickassu._65xx;

import kickass.asmnode.AsmNode;
import kickass.asmnode.output.ByteOutput;
import kickass.directives.asmmode.AsmDirective;
import kickass.expressions.ExprNode;
import kickass.state.EvaluationState;
import kickass.state.scope.SymbolScope;
import kickass.state.scope.symboltable.ISymbolPageIdx;
import kickass.state.scope.symboltable.SymbolStatus;
import kickass.values.LabelValue;
import kickass.values.NumberValue;
import kickass.values.Value;
import kickass.values._65xxArgumentValue;
import kickassu._65xx._65xxArgType;
import kickassu._65xx._65xxArgumentExpr;
import kickassu.errors.AsmError;
import kickassu.exceptions.AsmErrorException;
import kickassu.parsing.sourcelocation.SourceRange;

public class _65xxMnemonicNode
extends AsmDirective {
    private String mnemonic;
    private ExprNode argExpr;
    private int[] modes;
    private _65xxArgType argType;
    private String argLabelName;
    private ISymbolPageIdx argLabelsymbolPageIdx;
    private boolean labelIsResolved = false;

    private static _65xxArgType resolveExtension(String string, SourceRange sourceRange, EvaluationState evaluationState) {
        if (string.equals("imm") || string.equals("im")) {
            return _65xxArgType.immediate;
        }
        if (string.equals("zp") || string.equals("z")) {
            return _65xxArgType.zeropage;
        }
        if (string.equals("zpx") || string.equals("zx")) {
            return _65xxArgType.zeropageX;
        }
        if (string.equals("zpy") || string.equals("zy")) {
            return _65xxArgType.zeropageY;
        }
        if (string.equals("izpx") || string.equals("izx")) {
            return _65xxArgType.indirectZeropageX;
        }
        if (string.equals("izpy") || string.equals("izy")) {
            return _65xxArgType.indirectZeropageY;
        }
        if (string.equals("abs") || string.equals("a")) {
            return _65xxArgType.absolute;
        }
        if (string.equals("absx") || string.equals("ax")) {
            return _65xxArgType.absoluteX;
        }
        if (string.equals("absy") || string.equals("ay")) {
            return _65xxArgType.absoluteY;
        }
        if (string.equals("ind") || string.equals("i")) {
            return _65xxArgType.indirect;
        }
        if (string.equals("rel") || string.equals("r")) {
            return _65xxArgType.relative;
        }
        evaluationState.getErrors().add(new AsmError("Unknown extension: " + string, sourceRange));
        return null;
    }

    public static _65xxMnemonicNode createNode(String string, String string2, _65xxArgType _65xxArgType2, ExprNode exprNode, int[] nArray, String string3, SourceRange sourceRange, EvaluationState evaluationState) {
        _65xxArgType _65xxArgType3 = null;
        if (string2 != null && (_65xxArgType3 = _65xxMnemonicNode.resolveExtension(string2, sourceRange, evaluationState)) == null) {
            return null;
        }
        boolean bl = _65xxArgType2 == _65xxArgType.unresolvedAbsolute;
        _65xxArgumentExpr _65xxArgumentExpr2 = new _65xxArgumentExpr(_65xxArgType2, exprNode, bl);
        return new _65xxMnemonicNode(string, _65xxArgType3, _65xxArgumentExpr2, nArray, string3, sourceRange);
    }

    public _65xxMnemonicNode(String string, _65xxArgType _65xxArgType2, ExprNode exprNode, int[] nArray, String string2, SourceRange sourceRange) {
        super(sourceRange);
        this.argExpr = exprNode;
        this.mnemonic = string;
        this.argType = _65xxArgType2;
        this.modes = nArray;
        this.argLabelName = string2;
    }

    private _65xxMnemonicNode(String string, _65xxArgType _65xxArgType2, ExprNode exprNode, int[] nArray, String string2, SourceRange sourceRange, ISymbolPageIdx iSymbolPageIdx) {
        super(sourceRange);
        this.argExpr = exprNode;
        this.mnemonic = string;
        this.argType = _65xxArgType2;
        this.modes = nArray;
        this.argLabelName = string2;
        this.argLabelsymbolPageIdx = iSymbolPageIdx;
    }

    @Override
    public AsmNode copy() {
        return new _65xxMnemonicNode(this.mnemonic, this.argType, this.argExpr, this.modes, this.argLabelName, this.range, this.argLabelsymbolPageIdx);
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        if (this.argLabelName != null) {
            boolean bl = this.argLabelName.startsWith("@");
            String string = bl ? this.argLabelName.substring(1) : this.argLabelName;
            SymbolScope symbolScope = evaluationState.getRootOrCurrentScope(bl);
            if (symbolScope.isDefined(string)) {
                evaluationState.addError(new AsmError("The symbol '" + string + "' is already defined", this.range));
                return this;
            }
            this.argLabelsymbolPageIdx = symbolScope.define(string, LabelValue.initializer);
            this.argLabelsymbolPageIdx.setStatus(SymbolStatus.defined);
            this.argLabelsymbolPageIdx.setIsScopeExposed(true);
        }
        return this;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        this.argExpr.executePrepass(evaluationState);
        return this;
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        Object object;
        Value value;
        Integer n;
        Value value2;
        Object object2;
        evaluationState.clearFunctionSideOutput();
        boolean bl = false;
        if (this.argLabelName != null && !this.labelIsResolved) {
            object2 = evaluationState.getMemoryPosition();
            if (object2 == null) {
                bl = true;
            } else {
                value2 = (LabelValue)this.argLabelsymbolPageIdx.getValueHolder().getWithoutSideeffect();
                ((LabelValue)value2).resolveLabel(new NumberValue((Integer)object2 + 1));
                evaluationState.addResolvedSymbol(this.argLabelName, (Integer)object2 + 1);
                evaluationState.setMadeMetaProgress();
                this.labelIsResolved = true;
            }
        }
        Integer n2 = n = (value = ((_65xxArgumentValue)(value2 = _65xxArgumentValue.get65xxArg((Value)(object2 = this.argExpr.evaluate(evaluationState)), this.range))).getValue()).isInvalid() || ((_65xxArgumentValue)value2).get65xxArgType() == _65xxArgType.noArgument ? null : Integer.valueOf(value.getInt(this.range));
        if (this.argType == null) {
            this.argType = ((_65xxArgumentValue)value2).get65xxArgType();
        }
        if (!this.argType.isResolved()) {
            this.argType = this.resolveArgType(this.argType, n, this.modes);
        }
        int n3 = 1 + this.argType.getByteSize();
        evaluationState.increaseMemoryPosition(n3);
        int n4 = this.modes[this.argType.getIdNo()];
        if (n4 == -1) {
            throw new AsmErrorException("invalid adressingmode. '" + this.mnemonic + "' doesn't support " + (Object)((Object)this.argType) + " mode", this.range);
        }
        if (value.isInvalid()) {
            return this;
        }
        if (this.argType == _65xxArgType.relative) {
            object = evaluationState.getMemoryPosition();
            if (object == null) {
                return this;
            }
            if ((n = Integer.valueOf(n - (Integer)object)) < -128 || 127 < n) {
                throw new AsmErrorException("relative address is illegal (jump distance is too far).", this.range);
            }
        }
        object = new byte[n3];
        object[0] = (byte)n4;
        for (int i = 1; i < n3; ++i) {
            object[i] = (byte)(n & 0xFF);
            n = n >> 8;
        }
        if (bl || evaluationState.getErrorOrInvalidSideEffectsDuringFunctionEvaluation()) {
            return this;
        }
        return new ByteOutput((byte[])object, this.range, evaluationState.getFunctionSideOutput());
    }

    private _65xxArgType resolveArgType(_65xxArgType _65xxArgType2, Integer n, int[] nArray) {
        boolean bl;
        boolean bl2;
        _65xxArgType _65xxArgType3 = _65xxArgType2.getZpForm();
        boolean bl3 = bl2 = _65xxArgType3 != null && nArray[_65xxArgType3.getIdNo()] >= 0;
        if (bl2 && n != null && n <= 255) {
            return _65xxArgType3;
        }
        boolean bl4 = nArray[_65xxArgType.relative.getIdNo()] >= 0;
        boolean bl5 = bl = _65xxArgType2.getRelForm() != null;
        if (bl4 && bl) {
            return _65xxArgType.relative;
        }
        return _65xxArgType2.getAbsForm();
    }

    @Override
    public String toString() {
        return this.mnemonic;
    }
}

