/*
 * Decompiled with CFR 0.152.
 */
package kickass.values;

import kickass.function.Function;
import kickass.function.VectorDoubleFunction;
import kickass.function.VectorFunction;
import kickass.function.VectorX2Function;
import kickass.function.table.FunctionTable;
import kickass.function.table.StdFunctionTable;
import kickass.state.EvaluationState;
import kickass.valuerep.ValueRepresentation;
import kickass.valuerep.VectorRep;
import kickass.values.BooleanValue;
import kickass.values.ImmutableValue;
import kickass.values.InvalidValue;
import kickass.values.NumberValue;
import kickass.values.Value;
import kickassu.exceptions.AsmErrorException;
import kickassu.exceptions.AsmException;
import kickassu.parsing.sourcelocation.SourceRange;

public class VectorValue
extends ImmutableValue {
    public static VectorValue invalid = new VectorValue();
    private double[] values = new double[3];
    static FunctionTable functions = new StdFunctionTable(VectorValue.getStandardFunctions());

    private VectorValue() {
        this.setInvalid();
    }

    public VectorValue(double[] dArray) {
        for (int i = 0; i < 3; ++i) {
            this.values[i] = dArray[i];
        }
    }

    public VectorValue(double d, double d2, double d3) {
        this.values[0] = d;
        this.values[1] = d2;
        this.values[2] = d3;
    }

    @Override
    public String getType() {
        return "Vector";
    }

    @Override
    public Object getRepresentation(ValueRepresentation valueRepresentation) throws AsmException {
        if (valueRepresentation == VectorRep.representation) {
            return this.values.clone();
        }
        return null;
    }

    @Override
    public boolean hasString() {
        return true;
    }

    @Override
    public String getString(SourceRange sourceRange) {
        return this.isInvalid() ? "<<Invalid Vector>>" : "(" + this.values[0] + "," + this.values[1] + "," + this.values[2] + ")";
    }

    @Override
    public FunctionTable getFunctions() {
        return functions;
    }

    @Override
    public String toString() {
        return "Vector(" + this.values[0] + "," + this.values[1] + "," + this.values[2] + ")";
    }

    static {
        functions.add(new Function("get", 2, NumberValue.invalid){

            @Override
            public Value execute(Value[] valueArray, EvaluationState evaluationState, SourceRange sourceRange) {
                VectorValue vectorValue = (VectorValue)valueArray[0];
                int n = valueArray[1].getInt(sourceRange);
                if (n < 0 || 3 <= n) {
                    throw new AsmErrorException("Invalid index : " + n, sourceRange);
                }
                return new NumberValue(vectorValue.values[n]);
            }
        });
        functions.add(new Function("*", 2, InvalidValue.instance){

            @Override
            public Value execute(Value[] valueArray, EvaluationState evaluationState, SourceRange sourceRange) {
                double[] dArray = ((VectorValue)valueArray[0]).values;
                if (VectorRep.hasVector(valueArray[1])) {
                    double[] dArray2 = VectorRep.getVector(valueArray[1], sourceRange);
                    return new NumberValue(dArray[0] * dArray2[0] + dArray[1] * dArray2[1] + dArray[2] * dArray2[2]);
                }
                if (valueArray[1].hasDouble()) {
                    double d = valueArray[1].getDouble(sourceRange);
                    return new VectorValue(dArray[0] * d, dArray[1] * d, dArray[2] * d);
                }
                throw new AsmErrorException("Invalid argument. Can't get vector or number representation.", sourceRange);
            }
        });
        functions.add(new VectorFunction("getX", NumberValue.invalid){

            @Override
            protected Value f(double[] dArray) {
                return new NumberValue(dArray[0]);
            }
        });
        functions.add(new VectorFunction("getY", NumberValue.invalid){

            @Override
            protected Value f(double[] dArray) {
                return new NumberValue(dArray[1]);
            }
        });
        functions.add(new VectorFunction("getZ", NumberValue.invalid){

            @Override
            protected Value f(double[] dArray) {
                return new NumberValue(dArray[2]);
            }
        });
        functions.add(new VectorX2Function("+", invalid){

            @Override
            protected Value f(double[] dArray, double[] dArray2) {
                return new VectorValue(dArray[0] + dArray2[0], dArray[1] + dArray2[1], dArray[2] + dArray2[2]);
            }
        });
        functions.add(new VectorX2Function("-", invalid){

            @Override
            protected Value f(double[] dArray, double[] dArray2) {
                return new VectorValue(dArray[0] - dArray2[0], dArray[1] - dArray2[1], dArray[2] - dArray2[2]);
            }
        });
        functions.add(new VectorDoubleFunction("/", invalid){

            @Override
            protected Value f(double[] dArray, double d) {
                return new VectorValue(dArray[0] / d, dArray[1] / d, dArray[2] / d);
            }
        });
        functions.add(new VectorX2Function("X", invalid){

            @Override
            protected Value f(double[] dArray, double[] dArray2) {
                return new VectorValue(dArray[1] * dArray2[2] - dArray[2] * dArray2[1], dArray[2] * dArray2[0] - dArray[0] * dArray2[2], dArray[0] * dArray2[1] - dArray[1] * dArray2[0]);
            }
        });
        functions.add(new VectorX2Function("==", BooleanValue.invalid){

            @Override
            protected Value f(double[] dArray, double[] dArray2) {
                return BooleanValue.get(dArray[0] == dArray2[0] && dArray[1] == dArray2[1] && dArray[2] == dArray2[2]);
            }
        });
        functions.add(new VectorX2Function("!=", BooleanValue.invalid){

            @Override
            protected Value f(double[] dArray, double[] dArray2) {
                return BooleanValue.get(dArray[0] != dArray2[0] || dArray[1] != dArray2[1] || dArray[2] != dArray2[2]);
            }
        });
    }
}

