/*
 * Decompiled with CFR 0.152.
 */
package kickass.values;

import kickass.function.special.Function1Arg;
import kickass.function.table.FunctionTable;
import kickass.function.table.StdFunctionTable;
import kickass.state.EvaluationState;
import kickass.valueholder.IValueHolder;
import kickass.valuerep.ValueRepresentation;
import kickass.values.Lockable;
import kickass.values.NumberValue;
import kickass.values.StringValue;
import kickassu.exceptions.AsmErrorException;
import kickassu.parsing.sourcelocation.SourceRange;

public abstract class Value
implements Lockable {
    private boolean isInvalid = false;
    private static StdFunctionTable functions = null;

    public abstract String getType();

    public Object getRepresentation(ValueRepresentation valueRepresentation) {
        return null;
    }

    public boolean hasRepresentation(ValueRepresentation valueRepresentation) {
        return this.getRepresentation(valueRepresentation) != null;
    }

    public abstract FunctionTable getFunctions();

    protected IValueHolder localGetVariable(String string, SourceRange sourceRange) {
        return null;
    }

    public boolean isInvalid() {
        return this.isInvalid;
    }

    public boolean hasInvalidContent() {
        return false;
    }

    public boolean isInvalidOrInvalidContent() {
        return this.isInvalid() || this.hasInvalidContent();
    }

    protected void setInvalid() {
        this.isInvalid = true;
    }

    private static StdFunctionTable createStdFunctions() {
        StdFunctionTable stdFunctionTable = new StdFunctionTable();
        stdFunctionTable.add(new Function1Arg("lock", (value, sourceRange) -> {
            value.lock((SourceRange)sourceRange);
            return value;
        }));
        stdFunctionTable.add(new Function1Arg("number", NumberValue.invalid, (value, sourceRange) -> new NumberValue(value.getDouble((SourceRange)sourceRange))));
        stdFunctionTable.add(new Function1Arg("string", StringValue.invalid, (value, sourceRange) -> new StringValue(value.getString((SourceRange)sourceRange))));
        return stdFunctionTable;
    }

    protected static StdFunctionTable getStandardFunctions() {
        if (functions == null) {
            functions = Value.createStdFunctions();
        }
        return functions;
    }

    public IValueHolder getVariable(String string, SourceRange sourceRange) {
        IValueHolder iValueHolder = this.localGetVariable(string, sourceRange);
        if (iValueHolder == null) {
            throw new AsmErrorException("Variable '" + string + "' not present on value of type '" + this.getType() + "'", sourceRange);
        }
        return iValueHolder;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public Value operatorIndex(Value value, EvaluationState evaluationState, SourceRange sourceRange) {
        throw new AsmErrorException("[] operator not defined on value", sourceRange);
    }

    public boolean hasString() {
        return false;
    }

    public String getString(SourceRange sourceRange) {
        throw new AsmErrorException("Can't get a string representation from a value of type " + this.getType(), sourceRange);
    }

    public boolean hasBoolean() {
        return false;
    }

    public boolean getBoolean(SourceRange sourceRange) {
        throw new AsmErrorException("Can't get a boolean representation from a value of type " + this.getType(), sourceRange);
    }

    public boolean hasDouble() {
        return false;
    }

    public double getDouble(SourceRange sourceRange) {
        throw new AsmErrorException("Can't get a double representation from a value of type " + this.getType(), sourceRange);
    }

    public int getInt(SourceRange sourceRange) {
        return (int)this.getDouble(sourceRange);
    }

    public long getLong(SourceRange sourceRange) {
        return (long)this.getDouble(sourceRange);
    }
}

