/*
 * Decompiled with CFR 0.152.
 */
package kickass.values;

import java.util.ArrayList;
import kickass.function.table.FunctionTable;
import kickass.function.table.StdFunctionTable;
import kickass.state.EvaluationState;
import kickass.state.scope.SymbolScope;
import kickass.values.ImmutableValue;
import kickass.values.ScopeValue;
import kickass.values.Value;
import kickassu.errors.AsmError;
import kickassu.exceptions.AsmErrorException;
import kickassu.parsing.sourcelocation.SourceRange;

public class ScopeArrayValue
extends ImmutableValue {
    private SymbolScope scope;
    private boolean loopExecuted = false;
    private ArrayList<ScopeValue> scopeInstances = new ArrayList();
    protected static FunctionTable functions = new StdFunctionTable(ScopeArrayValue.getStandardFunctions());

    public ScopeArrayValue(SymbolScope symbolScope) {
        this.scope = symbolScope;
    }

    public static ScopeArrayValue getInvalidValue(SymbolScope symbolScope) {
        ScopeArrayValue scopeArrayValue = new ScopeArrayValue(symbolScope);
        scopeArrayValue.setInvalid();
        return scopeArrayValue;
    }

    public void setLoopExecuted() {
        this.loopExecuted = true;
    }

    public void addScopeValue(ScopeValue scopeValue) {
        this.scopeInstances.add(scopeValue);
    }

    @Override
    public Value operatorIndex(Value value, EvaluationState evaluationState, SourceRange sourceRange) {
        boolean bl;
        if (this.isInvalid() || value.isInvalid()) {
            return ScopeValue.getInvalidValue(this.scope);
        }
        int n = value.getInt(sourceRange);
        boolean bl2 = bl = this.loopExecuted && this.scopeInstances.size() <= n;
        if (n < 0 || bl) {
            throw new AsmErrorException(new AsmError("Index out of range: " + n, sourceRange));
        }
        if (this.scopeInstances.size() <= n) {
            return ScopeValue.getInvalidValue(this.scope);
        }
        return this.scopeInstances.get(n);
    }

    @Override
    public FunctionTable getFunctions() {
        return functions;
    }

    @Override
    public String getType() {
        return null;
    }
}

