/*
 * Decompiled with CFR 0.152.
 */
package kickass.values;

import java.util.HashMap;
import kickass.function.Function;
import kickass.function.table.FunctionTable;
import kickass.function.table.StdFunctionTable;
import kickass.state.EvaluationState;
import kickass.valueholder.ConstantValueHolder;
import kickass.valueholder.IValueHolder;
import kickass.values.ColorMapper;
import kickass.values.ColorTable;
import kickass.values.ImmutableValue;
import kickass.values.NumberValue;
import kickass.values.Value;
import kickassu.exceptions.AsmErrorException;
import kickassu.exceptions.AsmException;
import kickassu.parsing.sourcelocation.SourceRange;

public class PictureValue
extends ImmutableValue {
    public static Value invalid = new PictureValue();
    private int[] pixels;
    private int width;
    private int height;
    private ColorMapper colorTable = null;
    private ConstantValueHolder widthHolder;
    private ConstantValueHolder heightHolder;
    static FunctionTable functions = new StdFunctionTable(PictureValue.getStandardFunctions());

    public PictureValue() {
        this.setInvalid();
    }

    public PictureValue(int n, int n2, int[] nArray, int[] nArray2) {
        this.pixels = nArray;
        this.width = n;
        this.height = n2;
        this.widthHolder = new ConstantValueHolder(new NumberValue(n));
        this.heightHolder = new ConstantValueHolder(new NumberValue(n2));
        this.colorTable = nArray2 != null ? PictureValue.createColorTable(nArray2) : PictureValue.createDefaultColorTable(nArray, 0);
    }

    @Override
    public String getType() {
        return "Picture";
    }

    @Override
    public boolean hasString() {
        return true;
    }

    @Override
    public String getString(SourceRange sourceRange) {
        return this.isInvalid() ? "<<Invalid Picture>>" : "Picture";
    }

    @Override
    public FunctionTable getFunctions() {
        return functions;
    }

    @Override
    public IValueHolder localGetVariable(String string, SourceRange sourceRange) throws AsmException {
        if (this.isInvalid()) {
            return new ConstantValueHolder(NumberValue.invalid);
        }
        if (string.equals("width")) {
            return this.widthHolder;
        }
        if (string.equals("height")) {
            return this.heightHolder;
        }
        return null;
    }

    private int getPixel(int n, int n2, SourceRange sourceRange) throws AsmException {
        if (n < 0 || this.width <= n) {
            throw new AsmErrorException("x coordinate out of range : " + n, sourceRange);
        }
        if (n2 < 0 || this.height <= n2) {
            throw new AsmErrorException("y coordinate out of range : " + n2, sourceRange);
        }
        return this.pixels[n + n2 * this.width] & 0xFFFFFF;
    }

    private int getMulticolorByte(int n, int n2, SourceRange sourceRange) throws AsmException {
        int n3 = n * 8;
        if (n3 < 0 || this.width <= n3) {
            throw new AsmErrorException("byte x coordinate out of range : " + n, sourceRange);
        }
        if (n2 < 0 || this.height <= n2) {
            throw new AsmErrorException("y coordinate out of range : " + n2, sourceRange);
        }
        int n4 = n3 + n2 * this.width;
        int n5 = this.pixels[n4];
        int n6 = n3 + 2 >= this.width ? 0 : this.pixels[n4 + 2];
        int n7 = n3 + 4 >= this.width ? 0 : this.pixels[n4 + 4];
        int n8 = n3 + 6 >= this.width ? 0 : this.pixels[n4 + 6];
        int n9 = (this.colorTable.getColor(n5) & 3) << 6 | (this.colorTable.getColor(n6) & 3) << 4 | (this.colorTable.getColor(n7) & 3) << 2 | this.colorTable.getColor(n8) & 3;
        return n9;
    }

    private int getSinglecolorByte(int n, int n2, SourceRange sourceRange) throws AsmException {
        int n3 = n * 8;
        if (n3 < 0 || this.width <= n3) {
            throw new AsmErrorException("byte x coordinate out of range : " + n, sourceRange);
        }
        if (n2 < 0 || this.height <= n2) {
            throw new AsmErrorException("y coordinate out of range : " + n2, sourceRange);
        }
        int n4 = n3 + n2 * this.width;
        int n5 = this.pixels[n4];
        int n6 = n3 + 1 >= this.width ? 0 : this.pixels[n4 + 1];
        int n7 = n3 + 2 >= this.width ? 0 : this.pixels[n4 + 2];
        int n8 = n3 + 3 >= this.width ? 0 : this.pixels[n4 + 3];
        int n9 = n3 + 4 >= this.width ? 0 : this.pixels[n4 + 4];
        int n10 = n3 + 5 >= this.width ? 0 : this.pixels[n4 + 5];
        int n11 = n3 + 6 >= this.width ? 0 : this.pixels[n4 + 6];
        int n12 = n3 + 7 >= this.width ? 0 : this.pixels[n4 + 7];
        int n13 = (this.colorTable.getColor(n5) & 1) << 7 | (this.colorTable.getColor(n6) & 1) << 6 | (this.colorTable.getColor(n7) & 1) << 5 | (this.colorTable.getColor(n8) & 1) << 4 | (this.colorTable.getColor(n9) & 1) << 3 | (this.colorTable.getColor(n10) & 1) << 2 | (this.colorTable.getColor(n11) & 1) << 1 | this.colorTable.getColor(n12) & 1;
        return n13;
    }

    private static ColorTable createDefaultColorTable(int[] nArray, int n) {
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        int n2 = 0;
        if (n >= 0) {
            hashMap.put(n, n2);
            ++n2;
        }
        for (int i = 0; i < nArray.length && n2 < 4; ++i) {
            int n3 = nArray[i] & 0xFFFFFF;
            if (hashMap.get(n3) != null) continue;
            hashMap.put(n3, n2);
            ++n2;
        }
        return new ColorTable(hashMap);
    }

    private static ColorTable createColorTable(int[] nArray) {
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = nArray[i] & 0xFFFFFF;
            if (hashMap.get(n2) != null) continue;
            hashMap.put(n2, n);
            ++n;
        }
        return new ColorTable(hashMap);
    }

    static {
        functions.add(new PictureXYFunction("getPixel", NumberValue.invalid){

            @Override
            protected Value f(PictureValue pictureValue, int n, int n2, SourceRange sourceRange) {
                return new NumberValue(pictureValue.getPixel(n, n2, sourceRange));
            }
        });
        functions.add(new PictureXYFunction("getMulticolorByte", NumberValue.invalid){

            @Override
            protected Value f(PictureValue pictureValue, int n, int n2, SourceRange sourceRange) {
                return new NumberValue(pictureValue.getMulticolorByte(n, n2, sourceRange));
            }
        });
        functions.add(new PictureXYFunction("getSinglecolorByte", NumberValue.invalid){

            @Override
            protected Value f(PictureValue pictureValue, int n, int n2, SourceRange sourceRange) {
                return new NumberValue(pictureValue.getSinglecolorByte(n, n2, sourceRange));
            }
        });
    }

    public static abstract class PictureXYFunction
    extends Function {
        public PictureXYFunction(String string, Value value) {
            super(string, 3, value);
        }

        @Override
        public Value execute(Value[] valueArray, EvaluationState evaluationState, SourceRange sourceRange) {
            PictureValue pictureValue = (PictureValue)valueArray[0];
            int n = valueArray[1].getInt(sourceRange);
            int n2 = valueArray[2].getInt(sourceRange);
            return this.f(pictureValue, n, n2, sourceRange);
        }

        protected abstract Value f(PictureValue var1, int var2, int var3, SourceRange var4);
    }
}

