/*
 * Decompiled with CFR 0.152.
 */
package kickass.values;

import kickass.asmnode.output.reciever.OutputStreamType;
import kickass.function.Function;
import kickass.function.table.FunctionTable;
import kickass.function.table.StdFunctionTable;
import kickass.state.EvaluationState;
import kickass.values.BooleanValue;
import kickass.values.ImmutableValue;
import kickass.values.NullValue;
import kickass.values.StringValue;
import kickass.values.Value;
import kickassu.exceptions.AsmErrorException;
import kickassu.parsing.sourcelocation.SourceRange;

public class OutputFileValue
extends ImmutableValue {
    private static String newline = System.getProperty("line.separator");
    public static OutputFileValue invalid = new OutputFileValue();
    private String filename;
    static FunctionTable functions = new StdFunctionTable(OutputFileValue.getStandardFunctions());

    private OutputFileValue() {
        this.setInvalid();
    }

    public OutputFileValue(String string, EvaluationState evaluationState) {
        this.filename = string;
        evaluationState.addStreamOutput(OutputStreamType.FILE, string, "");
    }

    @Override
    public FunctionTable getFunctions() {
        return functions;
    }

    @Override
    public String getType() {
        return "OutputFile";
    }

    static {
        functions.add(new Function("writeln", 2, BooleanValue.invalid){

            @Override
            public Value execute(Value[] valueArray, EvaluationState evaluationState, SourceRange sourceRange) {
                Value value;
                if (valueArray.length > 2) {
                    throw new AsmErrorException("Cannot use more than 1 argument", sourceRange);
                }
                OutputFileValue outputFileValue = (OutputFileValue)valueArray[0];
                Value value2 = value = valueArray.length == 1 ? StringValue.emptyString : valueArray[1];
                if (outputFileValue.isInvalid() || value.isInvalid()) {
                    evaluationState.setErrorDuringFunctionEvaluation(true);
                    return NullValue.instance;
                }
                evaluationState.addStreamOutput(OutputStreamType.FILE, outputFileValue.filename, value.getString(sourceRange) + newline);
                return NullValue.instance;
            }
        });
    }
}

