/*
 * Decompiled with CFR 0.152.
 */
package kickass.values;

import kickass.function.Function;
import kickass.function.table.FunctionTable;
import kickass.function.table.StdFunctionTable;
import kickass.state.EvaluationState;
import kickass.values.BooleanValue;
import kickass.values.ImmutableValue;
import kickass.values.Value;
import kickassu.parsing.sourcelocation.SourceRange;

public class NullValue
extends ImmutableValue {
    public static final NullValue instance = new NullValue();
    static FunctionTable functions = new StdFunctionTable(NullValue.getStandardFunctions());

    public static Value nullIfNull(Value value) {
        return value == null ? instance : value;
    }

    private NullValue() {
    }

    @Override
    public String getType() {
        return "Null";
    }

    @Override
    public boolean hasString() {
        return true;
    }

    @Override
    public String getString(SourceRange sourceRange) {
        return "Null";
    }

    @Override
    public FunctionTable getFunctions() {
        return functions;
    }

    static {
        functions.add(new Function("==", 2, BooleanValue.invalid){

            @Override
            public Value execute(Value[] valueArray, EvaluationState evaluationState, SourceRange sourceRange) {
                return BooleanValue.get(valueArray[0] == valueArray[1]);
            }
        });
        functions.add(new Function("!=", 2, BooleanValue.invalid){

            @Override
            public Value execute(Value[] valueArray, EvaluationState evaluationState, SourceRange sourceRange) {
                return BooleanValue.get(valueArray[0] != valueArray[1]);
            }
        });
    }
}

