/*
 * Decompiled with CFR 0.152.
 */
package kickass.values;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import kickass.function.special.ValFunction1Arg;
import kickass.function.special.ValFunction2Arg;
import kickass.function.special.ValSAction1Arg;
import kickass.function.special.ValSAction2Arg;
import kickass.function.special.ValSAction3Arg;
import kickass.function.special.ValSActionVarArg;
import kickass.function.table.FunctionTable;
import kickass.function.table.StdFunctionTable;
import kickass.libraries.MathLibrary;
import kickass.tools.tuples.Pair;
import kickass.valuerep.ListRep;
import kickass.valuerep.ValueRepresentation;
import kickass.values.InvalidValue;
import kickass.values.LockableValue;
import kickass.values.NullValue;
import kickass.values.NumberValue;
import kickass.values.Value;
import kickassu.exceptions.AsmErrorException;
import kickassu.exceptions.AsmException;
import kickassu.parsing.sourcelocation.SourceRange;

public class ListValue
extends LockableValue {
    public static ListValue invalid = new ListValue();
    private ArrayList<Value> list = new ArrayList();
    boolean hasInvalidContent = false;
    static FunctionTable functions = new StdFunctionTable(ListValue.getStandardFunctions());

    private ListValue() {
        this.setInvalid();
    }

    public ListValue(int n) {
        for (int i = 0; i < n; ++i) {
            this.list.add(NullValue.instance);
        }
    }

    public ListValue(Iterable<Value> iterable) {
        for (Value value : iterable) {
            this.list.add(value);
        }
    }

    @Override
    public String getType() {
        return "List";
    }

    @Override
    public boolean hasInvalidContent() {
        return this.hasInvalidContent;
    }

    public void add(Value value) {
        this.list.add(value);
        if (value.isInvalidOrInvalidContent()) {
            this.hasInvalidContent = true;
        }
    }

    public void add(Value ... valueArray) {
        for (Value value : valueArray) {
            this.add(value);
        }
    }

    @Override
    public Object getRepresentation(ValueRepresentation valueRepresentation) {
        if (valueRepresentation == ListRep.representation) {
            return this.list;
        }
        return null;
    }

    @Override
    public boolean hasString() {
        return true;
    }

    @Override
    public String getString(SourceRange sourceRange) {
        if (this.isInvalid()) {
            return "<<Invalid List>>";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        for (int i = 0; i < this.list.size(); ++i) {
            if (i != 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(this.list.get(i).getString(null));
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    void checkForOutOfBound(int n, SourceRange sourceRange) throws AsmException {
        if (n < 0 || this.list.size() <= n) {
            throw new AsmErrorException("Index out of bound : " + n, sourceRange);
        }
    }

    @Override
    public FunctionTable getFunctions() {
        return functions;
    }

    @Override
    public void lock(SourceRange sourceRange) {
        if (this.isLocked) {
            return;
        }
        if (this.isInvalidOrInvalidContent()) {
            return;
        }
        this.isLocked = true;
        for (Value value : this.list) {
            value.lock(sourceRange);
        }
    }

    static {
        functions.add(new ValSActionVarArg<ListValue>("add", false, (listValue, valueArray, sourceRange) -> {
            listValue.ensureNotLocked((SourceRange)sourceRange);
            for (int i = 1; i < ((Value[])valueArray).length; ++i) {
                listValue.add(valueArray[i]);
            }
        }));
        functions.add(new ValSAction2Arg<ListValue>("addAll", false, (listValue, value, sourceRange) -> {
            listValue.ensureNotLocked((SourceRange)sourceRange);
            for (Value value2 : ListRep.getList(value, sourceRange)) {
                listValue.add(value2);
            }
        }));
        functions.add(new ValFunction2Arg<ListValue>("get", InvalidValue.instance, (listValue, value, sourceRange) -> {
            int n = value.getInt((SourceRange)sourceRange);
            listValue.checkForOutOfBound(n, (SourceRange)sourceRange);
            return listValue.list.get(n);
        }));
        functions.add(new ValSAction3Arg<ListValue>("set", false, (listValue, value, value2, sourceRange) -> {
            listValue.ensureNotLocked((SourceRange)sourceRange);
            if (value.isInvalid()) {
                listValue.setInvalid();
            }
            int n = value.getInt((SourceRange)sourceRange);
            listValue.checkForOutOfBound(n, (SourceRange)sourceRange);
            listValue.list.set(n, (Value)value2);
            if (value2.isInvalidOrInvalidContent()) {
                listValue.hasInvalidContent = true;
            }
        }));
        functions.add(new ValFunction2Arg<ListValue>("remove", (listValue, value, sourceRange) -> {
            listValue.ensureNotLocked((SourceRange)sourceRange);
            if (value.isInvalid()) {
                listValue.setInvalid();
                return listValue;
            }
            int n = value.getInt((SourceRange)sourceRange);
            listValue.checkForOutOfBound(n, (SourceRange)sourceRange);
            listValue.list.remove(n);
            return listValue;
        }));
        functions.add(new ValFunction1Arg<ListValue>("size", NumberValue.invalid, (listValue, sourceRange) -> new NumberValue(listValue.list.size())));
        functions.add(new ValSAction1Arg<ListValue>("shuffle", (listValue, sourceRange) -> {
            listValue.ensureNotLocked((SourceRange)sourceRange);
            Collections.shuffle(listValue.list, MathLibrary.getRandomGenerator());
        }));
        functions.add(new ValSAction1Arg<ListValue>("reverse", (listValue, sourceRange) -> {
            listValue.ensureNotLocked((SourceRange)sourceRange);
            Collections.reverse(listValue.list);
        }));
        functions.add(new ValSAction1Arg<ListValue>("sort", (listValue, sourceRange) -> {
            listValue.ensureNotLocked((SourceRange)sourceRange);
            ArrayList<Pair<Double, Value>> arrayList = new ArrayList<Pair<Double, Value>>();
            for (Value value : listValue.list) {
                Double d = value.hasDouble() ? value.getDouble((SourceRange)sourceRange) : Double.MAX_VALUE;
                arrayList.add(new Pair<Double, Value>(d, value));
            }
            Comparator<Pair<Double, Value>> comparator = new Comparator<Pair<Double, Value>>(){

                @Override
                public int compare(Pair<Double, Value> pair, Pair<Double, Value> pair2) {
                    return Double.compare(pair.getA(), pair2.getA());
                }
            };
            Collections.sort(arrayList, comparator);
            for (int i = 0; i < arrayList.size(); ++i) {
                listValue.list.set(i, (Value)((Pair)arrayList.get(i)).getB());
            }
        }));
    }
}

