/*
 * Decompiled with CFR 0.152.
 */
package kickass.values;

import kickass.function.Function;
import kickass.function.table.FunctionTable;
import kickass.state.EvaluationState;
import kickass.valueholder.IValueHolder;
import kickass.values.LockableValue;
import kickass.values.Value;
import kickassu.exceptions.AsmErrorException;
import kickassu.parsing.sourcelocation.SourceRange;

public class InvalidValue
extends LockableValue {
    public static final InvalidValue instance = new InvalidValue();
    private static FunctionTable functions = new InvalidValueFunctionTable();

    private InvalidValue() {
        this.setInvalid();
    }

    @Override
    public boolean hasString() {
        return true;
    }

    @Override
    public String getString(SourceRange sourceRange) {
        return "<<Invalid Value>>";
    }

    @Override
    public String getType() {
        return "Invalid value";
    }

    @Override
    public FunctionTable getFunctions() {
        return functions;
    }

    @Override
    public void lock(SourceRange sourceRange) {
    }

    @Override
    protected IValueHolder localGetVariable(String string, SourceRange sourceRange) {
        throw new AsmErrorException("You are trying to access a variable on an invalid value", sourceRange);
    }

    static class InvalidValueFunctionTable
    extends FunctionTable {
        InvalidValueFunctionTable() {
        }

        @Override
        public Function get(String string, int n) {
            return new Function(string, null, null, true){

                @Override
                public Value execute(Value[] valueArray, EvaluationState evaluationState, SourceRange sourceRange) {
                    throw new AsmErrorException("You are trying to call a function on an invalid object", sourceRange);
                }
            };
        }
    }
}

