/*
 * Decompiled with CFR 0.152.
 */
package kickass.values;

import kickass.function.Function;
import kickass.function.table.FunctionTable;
import kickass.state.EvaluationState;
import kickass.valueholder.IValueHolder;
import kickass.values.LockableValue;
import kickass.values.Value;
import kickassu.exceptions.AsmErrorException;
import kickassu.parsing.sourcelocation.SourceRange;

public class InvalidUnlockedSideEffectValue
extends LockableValue {
    private SourceRange setRange;

    public InvalidUnlockedSideEffectValue(SourceRange sourceRange) {
        this.setInvalid();
        this.setRange = sourceRange;
    }

    @Override
    public boolean isInvalid() {
        return true;
    }

    @Override
    public String getType() {
        this.throwException(null);
        return null;
    }

    @Override
    protected IValueHolder localGetVariable(String string, SourceRange sourceRange) {
        this.throwException(sourceRange);
        return null;
    }

    @Override
    public FunctionTable getFunctions() {
        return new InvalidValueFunctionTable();
    }

    @Override
    public void lock(SourceRange sourceRange) {
    }

    protected void throwException(SourceRange sourceRange) {
        String string = "(" + this.setRange.getFileName() + ":" + this.setRange.getStartLineNo() + ")";
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("You are trying to use an unlocked value accross passes. This is not supported. ");
        stringBuffer.append("Try locking the variable " + string + " with the .define directive or .lock() method before assigning it.");
        throw new AsmErrorException(stringBuffer.toString(), sourceRange);
    }

    class InvalidValueFunctionTable
    extends FunctionTable {
        InvalidValueFunctionTable() {
        }

        @Override
        public Function get(String string, int n) {
            return new Function(string, null, null, true){

                @Override
                public Value execute(Value[] valueArray, EvaluationState evaluationState, SourceRange sourceRange) {
                    InvalidUnlockedSideEffectValue.this.throwException(sourceRange);
                    return null;
                }
            };
        }
    }
}

