/*
 * Decompiled with CFR 0.152.
 */
package kickass.values;

import java.util.HashMap;
import java.util.Map;
import kickass.function.special.ValFunction1Arg;
import kickass.function.special.ValFunction2Arg;
import kickass.function.special.ValFunctionVarArg;
import kickass.function.table.FunctionTable;
import kickass.function.table.StdFunctionTable;
import kickass.values.BooleanValue;
import kickass.values.InvalidValue;
import kickass.values.ListValue;
import kickass.values.LockableValue;
import kickass.values.NullValue;
import kickass.values.StringValue;
import kickass.values.Value;
import kickassu.exceptions.AsmErrorException;
import kickassu.parsing.sourcelocation.SourceRange;

public class HashtableValue
extends LockableValue {
    private HashMap<String, Value> hashtable = new HashMap();
    private boolean hasInvalidContent = false;
    static FunctionTable functions = new StdFunctionTable(HashtableValue.getStandardFunctions());

    public HashtableValue addStringValues(Map<String, String> map) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.putValue(entry.getKey(), new StringValue(entry.getValue()));
        }
        return this;
    }

    public ListValue getKeyListValue() {
        ListValue listValue = new ListValue(0);
        for (String string : this.hashtable.keySet()) {
            listValue.add((Value)new StringValue(string));
        }
        return listValue;
    }

    void putValue(String string, Value value) {
        if (value.isInvalidOrInvalidContent()) {
            this.hasInvalidContent = true;
        }
        this.hashtable.put(string, value);
    }

    @Override
    public String getType() {
        return "Hashtable";
    }

    @Override
    public boolean hasInvalidContent() {
        return this.hasInvalidContent;
    }

    @Override
    public boolean hasString() {
        return true;
    }

    @Override
    public String getString(SourceRange sourceRange) {
        return this.isInvalid() ? "<<Invalid HashTable>>" : "Hashtable";
    }

    @Override
    public FunctionTable getFunctions() {
        return functions;
    }

    @Override
    public void lock(SourceRange sourceRange) {
        if (this.isLocked) {
            return;
        }
        this.isLocked = true;
        for (Value value : this.hashtable.values()) {
            value.lock(sourceRange);
        }
    }

    static {
        functions.add(new ValFunctionVarArg<HashtableValue>("put", (hashtableValue, valueArray, sourceRange) -> {
            int n = 1;
            while (n < ((Value[])valueArray).length) {
                String string = valueArray[n++].getString((SourceRange)sourceRange);
                if (n >= ((Value[])valueArray).length) {
                    throw new AsmErrorException("Missing value in key-value pair for hash table", (SourceRange)sourceRange);
                }
                Value value = valueArray[n++];
                hashtableValue.putValue(string, value);
            }
            return hashtableValue;
        }));
        functions.add(new ValFunction1Arg<HashtableValue>("keys", ListValue.invalid, (hashtableValue, sourceRange) -> hashtableValue.getKeyListValue()));
        functions.add(new ValFunction2Arg<HashtableValue>("get", InvalidValue.instance, (hashtableValue, value, sourceRange) -> NullValue.nullIfNull(hashtableValue.hashtable.get(value.getString((SourceRange)sourceRange)))));
        functions.add(new ValFunction2Arg<HashtableValue>("containsKey", BooleanValue.invalid, (hashtableValue, value, sourceRange) -> BooleanValue.get(hashtableValue.hashtable.containsKey(value.getString((SourceRange)sourceRange)))));
        functions.add(new ValFunction2Arg<HashtableValue>("remove", NullValue.instance, (hashtableValue, value, sourceRange) -> NullValue.nullIfNull(hashtableValue.hashtable.remove(value.getString((SourceRange)sourceRange)))));
    }
}

