/*
 * Decompiled with CFR 0.152.
 */
package kickass.values;

import kickass.function.Function;
import kickass.function.table.FunctionTable;
import kickass.function.table.StdFunctionTable;
import kickass.misc.CharToPetsciiConverter;
import kickass.state.EvaluationState;
import kickass.values.BooleanValue;
import kickass.values.NumberValue;
import kickass.values.Value;
import kickassu.parsing.sourcelocation.SourceRange;

public class CharValue
extends NumberValue {
    public static Value invalid = new CharValue();
    private char c;
    static FunctionTable functions = new StdFunctionTable((StdFunctionTable)NumberValue.functions);

    private CharValue() {
        super(Double.NaN);
        this.setInvalid();
    }

    public CharValue(char c) {
        super(Byte.valueOf(CharToPetsciiConverter.convert(c, true)).doubleValue());
        this.c = c;
    }

    @Override
    public String getType() {
        return this.isInvalid() ? "Invalid Char" : "Char";
    }

    @Override
    public boolean hasString() {
        return true;
    }

    @Override
    public String getString(SourceRange sourceRange) {
        return this.isInvalid() ? "<<Invalid Char>>" : String.valueOf(this.c);
    }

    @Override
    public FunctionTable getFunctions() {
        return functions;
    }

    static {
        functions.add(new Function("==", 2, BooleanValue.invalid){

            @Override
            public Value execute(Value[] valueArray, EvaluationState evaluationState, SourceRange sourceRange) {
                Value value = valueArray[0];
                Value value2 = valueArray[1];
                if (value2.hasDouble()) {
                    return BooleanValue.get(value.getDouble(sourceRange) == value2.getDouble(sourceRange));
                }
                return BooleanValue.get(value.getString(sourceRange).equals(value2.getString(sourceRange)));
            }
        }, true, null);
        functions.add(new Function("!=", 2, BooleanValue.invalid){

            @Override
            public Value execute(Value[] valueArray, EvaluationState evaluationState, SourceRange sourceRange) {
                Value value = valueArray[0];
                Value value2 = valueArray[1];
                if (value2.hasDouble()) {
                    return BooleanValue.get(value.getDouble(sourceRange) != value2.getDouble(sourceRange));
                }
                return BooleanValue.get(!value.getString(sourceRange).equals(value2.getString(sourceRange)));
            }
        }, true, null);
    }
}

