/*
 * Decompiled with CFR 0.152.
 */
package kickass.valueholder;

import kickass.referenceexpr.ReferenceOperation;
import kickass.sideeffect.SESymbolAssignment;
import kickass.state.EvaluationState;
import kickass.valueholder.IValueHolder;
import kickass.values.InvalidUnlockedSideEffectValue;
import kickass.values.Value;
import kickassu.exceptions.AsmErrorException;
import kickassu.parsing.sourcelocation.SourceRange;

public class ValueHolder
implements IValueHolder {
    private boolean recordSideEffect;
    private Value value;
    private ReferenceOperation allowedOperations;

    public ValueHolder(Value value, ReferenceOperation referenceOperation, boolean bl) {
        this.value = value;
        this.allowedOperations = referenceOperation;
        this.recordSideEffect = bl;
    }

    @Override
    public Value get(EvaluationState evaluationState, SourceRange sourceRange) {
        if (this.value == null) {
            throw new AsmErrorException("Symbol is not yet initialized", sourceRange);
        }
        return this.value;
    }

    @Override
    public Value getWithoutSideeffect() {
        return this.value;
    }

    @Override
    public void set(Value value, EvaluationState evaluationState, SourceRange sourceRange) {
        if (!this.allowedOperations.write()) {
            throw new AsmErrorException("Cannot write to a constant", sourceRange);
        }
        this.value = value;
        if (value.isInvalidOrInvalidContent()) {
            evaluationState.setInvalidSideEffectsDuringFunctionEvaluation();
        }
        if (this.recordSideEffect) {
            Value value2 = value.isLocked() ? value : new InvalidUnlockedSideEffectValue(sourceRange);
            evaluationState.addSideEffect(new SESymbolAssignment(value2, this));
        }
    }

    @Override
    public void setWithoutSideEffect(Value value) {
        this.value = value;
    }
}

