/*
 * Decompiled with CFR 0.152.
 */
package kickass.statements;

import kickass.expressions.ExprNode;
import kickass.state.EvaluationState;
import kickass.state.scope.SymbolScope;
import kickass.state.scope.symboltable.ISymbolInitializer;
import kickass.state.scope.symboltable.ISymbolPageIdx;
import kickass.state.scope.symboltable.SymbolStatus;
import kickass.statements.StmtNode;
import kickass.valueholder.FunctionVariableValueHolder;
import kickass.valueholder.IValueHolder;
import kickass.valueholder.VariableValueHolder;
import kickass.values.NullValue;
import kickass.values.Value;
import kickassu.errors.AsmError;
import kickassu.parsing.sourcelocation.SourceRange;

public class VariableDeclaration
extends StmtNode {
    private String name;
    private ExprNode initValueExpr = null;
    private ISymbolPageIdx symbolIdx;

    public VariableDeclaration(String string, ExprNode exprNode, SourceRange sourceRange) {
        super(sourceRange);
        this.name = string;
        this.initValueExpr = exprNode;
    }

    @Override
    public void executeMetaRegistrations(EvaluationState evaluationState) {
        boolean bl = this.name.startsWith("@");
        String string = bl ? this.name.substring(1) : this.name;
        SymbolScope symbolScope = evaluationState.getRootOrCurrentScope(bl);
        if (symbolScope.isDefined(string)) {
            evaluationState.addError(new AsmError("The symbol '" + this.name + "' is already defined", this.range));
            return;
        }
        ISymbolInitializer iSymbolInitializer = evaluationState.getFunctionsMode() ? FunctionVariableValueHolder.initializer : VariableValueHolder.initializer;
        this.symbolIdx = symbolScope.define(string, iSymbolInitializer);
    }

    @Override
    public void executePrepass(EvaluationState evaluationState) {
        if (this.symbolIdx == null) {
            return;
        }
        if (this.initValueExpr != null) {
            this.initValueExpr.executePrepass(evaluationState);
        }
        this.symbolIdx.setStatus(SymbolStatus.defined);
    }

    @Override
    public Value evaluate(EvaluationState evaluationState) {
        IValueHolder iValueHolder = this.symbolIdx.getValueHolder();
        NullValue nullValue = this.initValueExpr == null ? NullValue.instance : this.initValueExpr.evaluate(evaluationState);
        iValueHolder.set(nullValue, evaluationState, this.range);
        return nullValue;
    }

    public String toString() {
        return "VarDeclaration";
    }
}

