/*
 * Decompiled with CFR 0.152.
 */
package kickass.statements;

import kickass.expressions.ExprNode;
import kickass.sideeffect.SESymbolAssignment;
import kickass.state.EvaluationState;
import kickass.state.scope.SymbolScope;
import kickass.state.scope.symboltable.ISymbolPageIdx;
import kickass.state.scope.symboltable.SymbolStatus;
import kickass.statements.StmtNode;
import kickass.valueholder.ConstantValueHolder;
import kickass.valueholder.IValueHolder;
import kickass.values.Value;
import kickassu.errors.AsmError;
import kickassu.parsing.sourcelocation.SourceRange;

public class ConstDeclaration
extends StmtNode {
    private String name;
    private ExprNode expr;
    private ISymbolPageIdx symbolPageIdx;

    public ConstDeclaration(String string, ExprNode exprNode, SourceRange sourceRange) {
        super(sourceRange);
        this.name = string;
        this.expr = exprNode;
    }

    public String toString() {
        return "ConstDeclaration";
    }

    @Override
    public void executeMetaRegistrations(EvaluationState evaluationState) {
        boolean bl = this.name.startsWith("@");
        String string = bl ? this.name.substring(1) : this.name;
        SymbolScope symbolScope = evaluationState.getRootOrCurrentScope(bl);
        if (symbolScope.isDefined(string)) {
            evaluationState.addError(new AsmError("The symbol '" + this.name + "' is already defined", this.range));
            return;
        }
        this.symbolPageIdx = symbolScope.define(string, ConstantValueHolder.initializer);
    }

    @Override
    public void executePrepass(EvaluationState evaluationState) {
        this.expr.executePrepass(evaluationState);
        if (this.symbolPageIdx != null) {
            this.symbolPageIdx.setStatus(SymbolStatus.defined);
        }
    }

    @Override
    public Value evaluate(EvaluationState evaluationState) {
        Value value = this.expr.evaluate(evaluationState);
        if (value.isInvalidOrInvalidContent()) {
            evaluationState.setInvalidSideEffectsDuringFunctionEvaluation();
        }
        IValueHolder iValueHolder = this.symbolPageIdx.getValueHolder();
        iValueHolder.setWithoutSideEffect(value);
        if (!evaluationState.getFunctionsMode()) {
            evaluationState.addSideEffect(new SESymbolAssignment(value, iValueHolder));
        }
        return value;
    }
}

