/*
 * Decompiled with CFR 0.152.
 */
package kickass.state;

import cml.kickass.plugins.interf.IMacro;
import java.util.ArrayList;
import java.util.List;
import kickass.asmnode.output.reciever.OutputStreamType;
import kickass.constant.Constant;
import kickass.function.Function;
import kickass.function.functionselector.FunctionSelectorCreator;
import kickass.function.functionselector.IFunctionSelector;
import kickass.libraries.Library;
import kickass.libraries.MathLibrary;
import kickass.log.Log;
import kickass.plugins.impl.OldIMacroAdapter;
import kickass.plugins.impl.OldIModifierAdapter;
import kickass.plugins.interf.IArchive;
import kickass.plugins.interf.IModifier;
import kickass.sideeffect.SEIncreaseMemoryPosition;
import kickass.sideeffect.SESetMemoryPosition;
import kickass.sideeffect.SideEffect;
import kickass.state.AssertManager;
import kickass.state.CallStack;
import kickass.state.FileManager;
import kickass.state.FunctionSideOutput;
import kickass.state.namespace.Namespace;
import kickass.state.scope.SymbolScope;
import kickass.state.scope.symboltable.SymbolStatus;
import kickass.tools.collections.MultiEntryMap;
import kickass.tools.tuples.Pair;
import kickass.valueholder.ConstantValueHolder;
import kickassu.configuration.parameters.KickAssemblerParameters;
import kickassu.errors.AsmError;
import kickassu.parsing.preprocessor.PreprocessorState;
import kickassu.parsing.syntaxinfo.SyntaxInfo;

public class EvaluationState {
    private static Log log = new Log("");
    public static final int defaultMemoryPosition = 8192;
    private final long initSeed = (long)(Math.random() * 1.0E7);
    private KickAssemblerParameters kickAssemblerParams = new KickAssemblerParameters();
    private int maxMemoryAddress;
    private int passNo = -1;
    private boolean failOnInvalidValue;
    private boolean madeMetaProgress;
    private boolean functionMode = false;
    private boolean pseudoPcMode = false;
    private Integer currentMemoryPosition;
    private Integer currentRealMemoryPosition;
    private boolean errorDuringFunctionEvaluation;
    private boolean invalidSideEffectsDuringFunctionEvaluation;
    private FunctionSideOutput sideOutput = null;
    private Namespace systemNamespace = Namespace.getSystemNamespace();
    private Namespace rootNamespace;
    private Namespace currentNamespace = this.rootNamespace = new Namespace("<RootNS>", this.systemNamespace, true);
    private SymbolScope currentScope = this.currentNamespace.getScope();
    private List<Pair<String, Integer>> resolvedSymbols = new ArrayList<Pair<String, Integer>>();
    private CallStack callStack = new CallStack();
    private AssertManager assertManager = new AssertManager();
    private boolean expectErrors = false;
    private List<AsmError> errors = new ArrayList<AsmError>();
    private List<AsmError> expectedErrors;
    private List<SyntaxInfo> syntaxInfo = new ArrayList<SyntaxInfo>();
    private PreprocessorState preProcessorState = new PreprocessorState(this);
    private FileManager fileManager = new FileManager();

    public void prepareNewParse() {
        ++this.passNo;
        this.madeMetaProgress = false;
        MathLibrary.setSeed(this.initSeed);
        this.setMemoryPositionWithoutSideEffect(8192);
        this.currentNamespace = this.rootNamespace;
        this.currentScope = this.currentNamespace.getScope();
    }

    public void addError(AsmError asmError) {
        (this.expectErrors ? this.expectedErrors : this.errors).add(asmError);
    }

    public List<AsmError> getErrors() {
        return this.errors;
    }

    public void startExpectErrorsMode() {
        this.expectedErrors = new ArrayList<AsmError>();
        this.expectErrors = true;
    }

    public List<AsmError> endExpectErrorsMode() {
        this.expectErrors = false;
        return this.expectedErrors;
    }

    public void setRootNamespace(Namespace namespace) {
        this.rootNamespace = namespace;
    }

    public Namespace getRootNamespace() {
        return this.rootNamespace;
    }

    public void setCurrentNamespace(Namespace namespace) {
        this.currentNamespace = namespace;
    }

    public Namespace getCurrentNamespace() {
        return this.currentNamespace;
    }

    public Namespace replaceCurrentNamespace(Namespace namespace) {
        Namespace namespace2 = this.currentNamespace;
        this.currentNamespace = namespace;
        return namespace2;
    }

    public KickAssemblerParameters getKickAssemblerParams() {
        return this.kickAssemblerParams;
    }

    public void addSyntaxInfo(SyntaxInfo syntaxInfo) {
        this.syntaxInfo.add(syntaxInfo);
    }

    public List<SyntaxInfo> getSyntaxInfo() {
        return this.syntaxInfo;
    }

    public PreprocessorState getPreprocessoreState() {
        return this.preProcessorState;
    }

    public void setMaxMemoryAddress(int n) {
        this.maxMemoryAddress = n;
    }

    public int getMaxMemoryAddress() {
        return this.maxMemoryAddress;
    }

    public boolean failOnInvalidValue() {
        return this.failOnInvalidValue;
    }

    public void setFailOnInvalidValue(boolean bl) {
        this.failOnInvalidValue = bl;
    }

    public void setMadeMetaProgress() {
        this.madeMetaProgress = true;
    }

    public boolean getMadeMetaProgress() {
        return this.madeMetaProgress;
    }

    public void setPseudoPcMode(boolean bl) {
        this.pseudoPcMode = bl;
    }

    public boolean getPseudoPcMode() {
        return this.pseudoPcMode;
    }

    public boolean getFunctionsMode() {
        return this.functionMode;
    }

    public void setFunctionMode(boolean bl) {
        this.functionMode = bl;
    }

    public boolean replaceFunctionMode(boolean bl) {
        boolean bl2 = this.functionMode;
        this.functionMode = bl;
        return bl2;
    }

    public AssertManager getAssertManager() {
        return this.assertManager;
    }

    public CallStack getCallStack() {
        return this.callStack;
    }

    public int getPassNo() {
        return this.passNo;
    }

    public void addResolvedSymbol(String string, Integer n) {
        this.resolvedSymbols.add(new Pair<String, Integer>(string, n));
    }

    public List<Pair<String, Integer>> getResolvedSymbols() {
        return this.resolvedSymbols;
    }

    public FileManager getFileManager() {
        return this.fileManager;
    }

    public void addPlugin(Object object) {
        Object object2;
        boolean bl = false;
        if (object instanceof IArchive) {
            object2 = (IArchive)object;
            for (Object object3 : object2.getPluginObjects()) {
                this.addPlugin(object3);
            }
            bl = true;
        }
        if (object instanceof kickass.plugins.interf.IMacro) {
            object2 = (kickass.plugins.interf.IMacro)object;
            this.systemNamespace.getMacroPlugins().put(object2.getName(), (kickass.plugins.interf.IMacro)object2);
            bl = true;
        }
        if (object instanceof IModifier) {
            object2 = (IModifier)object;
            this.systemNamespace.getModifierPlugins().put(object2.getName(), (IModifier)object2);
            bl = true;
        }
        if (object instanceof cml.kickass.plugins.interf.IArchive) {
            object2 = (cml.kickass.plugins.interf.IArchive)object;
            for (Object object3 : object2.getPluginObjects()) {
                this.addPlugin(object3);
            }
            bl = true;
        }
        if (object instanceof IMacro) {
            object2 = (IMacro)object;
            this.systemNamespace.getMacroPlugins().put(object2.getName(), new OldIMacroAdapter((IMacro)object2));
            bl = true;
        }
        if (object instanceof cml.kickass.plugins.interf.IModifier) {
            object2 = (cml.kickass.plugins.interf.IModifier)object;
            this.systemNamespace.getModifierPlugins().put(object2.getName(), new OldIModifierAdapter((cml.kickass.plugins.interf.IModifier)object2));
            bl = true;
        }
        if (!bl) {
            log.println("Warning: The following object registered as a user-plugin but don't implements any plugin interfaces : " + object.getClass().getName());
        }
    }

    public void addLibrary(Library library, Namespace namespace) {
        Object object;
        String string = library.getClass().getSimpleName();
        for (Constant iterator : library.getConstants()) {
            SymbolScope symbolScope = namespace.getScope();
            if (symbolScope.isDefined(iterator.getName())) {
                object = "Error while adding the constant '" + iterator.getName() + "' from the library '" + string + "'. The symbol already exist!";
                this.addError(new AsmError((String)object, null));
                continue;
            }
            object = symbolScope.define(iterator.getName(), iValueHolderArray -> new ConstantValueHolder(iterator.getValue()));
            object.setStatus(SymbolStatus.defined);
        }
        MultiEntryMap multiEntryMap = new MultiEntryMap();
        for (Function function : library.getFunctions()) {
            multiEntryMap.add(function.getName(), function);
        }
        for (String string2 : multiEntryMap.keySet()) {
            object = multiEntryMap.get(string2);
            IFunctionSelector iFunctionSelector = FunctionSelectorCreator.create((List<Function>)object);
            namespace.getFunctions().put(string2, iFunctionSelector);
        }
    }

    public void clearFunctionSideOutput() {
        this.sideOutput = null;
        this.errorDuringFunctionEvaluation = false;
        this.invalidSideEffectsDuringFunctionEvaluation = false;
    }

    public FunctionSideOutput getFunctionSideOutput() {
        return this.sideOutput;
    }

    public void addSideEffect(SideEffect sideEffect) {
        this.getOrNewFunctionSideOutput().addSideEffect(sideEffect);
    }

    public void addTextOutput(String string) {
        this.addStreamOutput(OutputStreamType.CONSOLE, null, string);
    }

    public void addStreamOutput(OutputStreamType outputStreamType, String string, Object object) {
        this.getOrNewFunctionSideOutput().addStreamOutput(outputStreamType, string, object);
    }

    private FunctionSideOutput getOrNewFunctionSideOutput() {
        if (this.sideOutput == null) {
            this.sideOutput = new FunctionSideOutput();
        }
        return this.sideOutput;
    }

    public boolean getErrorDuringFunctionEvaluation() {
        return this.errorDuringFunctionEvaluation;
    }

    public boolean getInvalidSideEffectsDuringFunctionEvaluation() {
        return this.invalidSideEffectsDuringFunctionEvaluation;
    }

    public boolean getErrorOrInvalidSideEffectsDuringFunctionEvaluation() {
        return this.getErrorDuringFunctionEvaluation() || this.getInvalidSideEffectsDuringFunctionEvaluation();
    }

    public void setErrorDuringFunctionEvaluation(boolean bl) {
        this.errorDuringFunctionEvaluation = bl;
    }

    public void setInvalidSideEffectsDuringFunctionEvaluation() {
        this.invalidSideEffectsDuringFunctionEvaluation = true;
    }

    public SymbolScope getRootScope() {
        return this.rootNamespace.getScope();
    }

    public SymbolScope getCurrentScope() {
        return this.currentScope;
    }

    public void setCurrentScope(SymbolScope symbolScope) {
        this.currentScope = symbolScope;
    }

    public SymbolScope replaceCurrentScope(SymbolScope symbolScope) {
        SymbolScope symbolScope2 = this.currentScope;
        this.currentScope = symbolScope;
        return symbolScope2;
    }

    public Namespace getSystemNamespace() {
        return this.systemNamespace;
    }

    public Namespace getRootOrCurrentNamespace(boolean bl) {
        return bl ? this.rootNamespace : this.currentNamespace;
    }

    public SymbolScope getRootOrCurrentScope(boolean bl) {
        return bl ? this.rootNamespace.getScope() : this.currentScope;
    }

    public Integer getMemoryPosition() {
        return this.currentMemoryPosition;
    }

    public Integer getRealMemoryPosition() {
        return this.currentRealMemoryPosition;
    }

    public void setRealMemoryPosition(Integer n) {
        this.currentRealMemoryPosition = n;
    }

    public void setMemoryPosition(Integer n) {
        this.setMemoryPositionWithoutSideEffect(n);
        if (n == null) {
            this.setErrorDuringFunctionEvaluation(true);
        } else {
            this.addSideEffect(new SESetMemoryPosition(n));
        }
    }

    public void setMemoryPositionWithoutSideEffect(Integer n) {
        this.currentMemoryPosition = n;
        this.currentRealMemoryPosition = n;
    }

    public void increaseMemoryPosition(int n) {
        this.increaseMemoryPositionWithoutSideEffect(n);
        this.addSideEffect(new SEIncreaseMemoryPosition(n));
    }

    public void increaseMemoryPositionWithoutSideEffect(int n) {
        if (this.currentMemoryPosition != null) {
            this.currentMemoryPosition = this.currentMemoryPosition + n;
        }
        if (this.currentRealMemoryPosition != null) {
            this.currentRealMemoryPosition = this.currentRealMemoryPosition + n;
        }
    }
}

