/*
 * Decompiled with CFR 0.152.
 */
package kickass.referenceexpr;

import kickass.referenceexpr.IReferenceExpr;
import kickass.referenceexpr.ReferenceOperation;
import kickass.state.EvaluationState;
import kickass.state.MetaConstructPosition;
import kickass.state.scope.symboltable.ISymbolPageIdx;
import kickass.state.scope.symboltable.SymbolStatus;
import kickass.valueholder.IValueHolder;
import kickassu.errors.AsmError;
import kickassu.parsing.sourcelocation.SourceRange;

public class SymbolReferenceExpr
implements IReferenceExpr {
    private boolean isRootScope;
    private String name;
    private SourceRange range;
    private ISymbolPageIdx symbolPageIdx;

    public SymbolReferenceExpr(String string, SourceRange sourceRange) {
        this.range = sourceRange;
        this.isRootScope = string.startsWith("@");
        this.name = this.isRootScope ? string.substring(1) : string;
    }

    @Override
    public SourceRange getSourceRange() {
        return this.range;
    }

    @Override
    public void executePrepass(EvaluationState evaluationState, ReferenceOperation referenceOperation) {
        this.symbolPageIdx = evaluationState.getRootOrCurrentScope(this.isRootScope).get(this.name);
        if (this.symbolPageIdx == null) {
            evaluationState.addError(new AsmError("Unknown symbol '" + this.name + "'", this.range));
        } else if (this.symbolPageIdx.getStatus() == SymbolStatus.undefined) {
            boolean bl;
            MetaConstructPosition metaConstructPosition = this.symbolPageIdx.getMetaConstructPosition();
            MetaConstructPosition metaConstructPosition2 = evaluationState.getCurrentScope().getMetaConstructPosition();
            boolean bl2 = bl = metaConstructPosition2 != MetaConstructPosition.outside && metaConstructPosition != metaConstructPosition2;
            if (!bl) {
                evaluationState.addError(new AsmError("Reference to not yet defined symbol '" + this.name + "'", this.range));
            }
        }
    }

    @Override
    public IValueHolder getValueHolder(EvaluationState evaluationState) {
        return this.symbolPageIdx.getValueHolder();
    }
}

