/*
 * Decompiled with CFR 0.152.
 */
package kickass.referenceexpr;

import kickass.referenceexpr.IReferenceExpr;
import kickass.referenceexpr.ReferenceOperation;
import kickass.state.EvaluationState;
import kickass.state.scope.symboltable.ISymbolPageIdx;
import kickass.valueholder.IValueHolder;
import kickassu.errors.AsmError;
import kickassu.parsing.sourcelocation.SourceRange;

public class MultiSymbolReferenceExpr
implements IReferenceExpr {
    private String fullName;
    private SourceRange range;
    private ISymbolPageIdx symbolIdx;

    public MultiSymbolReferenceExpr(String string, SourceRange sourceRange) {
        this.range = sourceRange;
        this.fullName = string;
    }

    @Override
    public void executePrepass(EvaluationState evaluationState, ReferenceOperation referenceOperation) {
        int n;
        if (this.fullName.endsWith("-")) {
            n = 0;
        } else if (this.fullName.endsWith("+")) {
            n = 1;
        } else {
            evaluationState.addError(new AsmError("Missing direction on multilabel reference '" + this.fullName + "'", this.range));
            return;
        }
        String string = this.fullName.substring(0, this.fullName.length() - 1);
        this.symbolIdx = evaluationState.getCurrentScope().getMultiSymbol(string, n);
        if (this.symbolIdx == null) {
            evaluationState.addError(new AsmError("Unknown symbol '" + this.fullName + "'", this.range));
        }
    }

    @Override
    public IValueHolder getValueHolder(EvaluationState evaluationState) {
        return this.symbolIdx.getValueHolder();
    }

    public String toString() {
        return "MultiLabelReference(" + this.fullName + ")";
    }

    @Override
    public SourceRange getSourceRange() {
        return this.range;
    }
}

