/*
 * Decompiled with CFR 0.152.
 */
package kickass.misc;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import kickass.log.Log;
import kickass.state.namespace.Namespace;
import kickass.state.scope.SymbolScope;
import kickass.state.scope.symboltable.ISymbolPageIdx;
import kickass.values.LabelValue;
import kickass.values.NamespaceValue;
import kickass.values.ScopeValue;
import kickass.values.Value;

public class SymbolFile {
    private static String newline = System.getProperty("line.separator");
    private static Log log = new Log("SymbolFile");
    private Namespace rootNamespace;
    private String indent = "  ";

    public SymbolFile(Namespace namespace) {
        this.rootNamespace = namespace;
    }

    public void writeFile(String string) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
            this.writeScope(0, this.rootNamespace.getScope(), bufferedWriter);
            ((Writer)bufferedWriter).close();
        }
        catch (IOException iOException) {
            log.error("IO error while writing symbol file '" + string + "':" + iOException.getMessage());
        }
        catch (Exception exception) {
            log.error("Internal error while writing symbol file '" + string + "'. Contact the author");
            exception.printStackTrace(System.out);
        }
    }

    private void writeScope(int n, SymbolScope symbolScope, Writer writer) throws IOException {
        boolean bl;
        boolean bl2 = bl = symbolScope.getSymbolTable() == this.rootNamespace.getScope().getSymbolTable();
        if (!bl) {
            return;
        }
        String string = this.getIndent(n);
        Map<String, ISymbolPageIdx> map = symbolScope.getLocalDefinedEntities();
        for (Map.Entry<String, ISymbolPageIdx> entry : map.entrySet()) {
            boolean bl3;
            String string2 = entry.getKey();
            Value value = entry.getValue().getValueHolder().getWithoutSideeffect();
            boolean bl4 = value instanceof NamespaceValue;
            if (bl4) {
                writer.write(string + ".namespace " + string2 + " {" + newline);
                this.writeScope(n + 1, ((NamespaceValue)value).getScope(), writer);
                writer.write(string + "}" + newline);
                continue;
            }
            boolean bl5 = value instanceof LabelValue;
            if (!bl5) continue;
            LabelValue labelValue = (LabelValue)value;
            Value value2 = labelValue.getConnectedValue();
            String string3 = Integer.toHexString(value.getInt(null));
            boolean bl6 = bl3 = value2 == null;
            if (bl3) {
                writer.write(string + ".label " + string2 + "=$" + string3 + newline);
                continue;
            }
            boolean bl7 = value2 instanceof ScopeValue;
            if (!bl7) continue;
            writer.write(string + ".label " + string2 + "=$" + string3 + " {" + newline);
            this.writeScope(n + 1, ((ScopeValue)value2).getScope(), writer);
            writer.write(string + "}" + newline);
        }
    }

    private String getIndent(int n) {
        String string = "";
        while (n > 0) {
            string = string + this.indent;
            --n;
        }
        return string;
    }
}

