/*
 * Decompiled with CFR 0.152.
 */
package kickass.misc;

import java.util.HashMap;
import java.util.Map;

public class CharToPetsciiConverter {
    private static Object[] petsciiTable_mixed = new Object[]{5, 61696, 8, 61720, 9, 61721, 13, 13, 14, 14, 17, 61724, 18, 61722, 19, 61728, 20, 127, 28, 61697, 29, 61725, 30, 61698, 31, 61699, 32, 32, 33, 33, 34, 34, 35, 35, 36, 36, 37, 37, 38, 38, 39, 39, 40, 40, 41, 41, 42, 42, 43, 43, 44, 44, 45, 45, 46, 46, 47, 47, 48, 48, 49, 49, 50, 50, 51, 51, 52, 52, 53, 53, 54, 54, 55, 55, 56, 56, 57, 57, 58, 58, 59, 59, 60, 60, 61, 61, 62, 62, 63, 63, 64, 64, 65, 97, 66, 98, 67, 99, 68, 100, 69, 101, 70, 102, 71, 103, 72, 104, 73, 105, 74, 106, 75, 107, 76, 108, 77, 109, 78, 110, 79, 111, 80, 112, 81, 113, 82, 114, 83, 115, 84, 116, 85, 117, 86, 118, 87, 119, 88, 120, 89, 121, 90, 122, 91, 91, 92, 163, 93, 93, 94, 8593, 95, 8592, 96, 9473, 97, 65, 98, 66, 99, 67, 100, 68, 101, 69, 102, 70, 103, 71, 104, 72, 105, 73, 106, 74, 107, 75, 108, 76, 109, 77, 110, 78, 111, 79, 112, 80, 113, 81, 114, 82, 115, 83, 116, 84, 117, 85, 118, 86, 119, 87, 120, 88, 121, 89, 122, 90, 123, 9532, 124, 61742, 125, 9474, 126, 9618, 127, 61753, 129, 61700, 133, 61712, 134, 61714, 135, 61716, 136, 61718, 137, 61713, 138, 61715, 139, 61717, 140, 61719, 141, 10, 142, 15, 144, 61701, 145, 61726, 146, 61723, 147, 12, 148, 61729, 149, 61702, 150, 61703, 151, 61704, 152, 61705, 153, 61706, 154, 61707, 155, 61708, 156, 61709, 157, 61725, 158, 61710, 159, 61711, 160, 160, 161, 9612, 162, 9604, 163, 9620, 164, 9601, 165, 9615, 166, 9618, 167, 9621, 168, 61743, 169, 61754, 170, 61744, 171, 9500, 172, 61748, 173, 9492, 174, 9488, 175, 9602, 176, 9484, 177, 9524, 178, 9516, 179, 9508, 180, 9614, 181, 9613, 182, 61745, 183, 61746, 184, 61747, 185, 9603, 186, 10003, 187, 61749, 188, 61750, 189, 9496, 190, 61751, 191, 61752, 192, 9473, 193, 65, 194, 66, 195, 67, 196, 68, 197, 69, 198, 70, 199, 71, 200, 72, 201, 73, 202, 74, 203, 75, 204, 76, 205, 77, 206, 78, 207, 79, 208, 80, 209, 81, 210, 82, 211, 83, 212, 84, 213, 85, 214, 86, 215, 87, 216, 88, 217, 89, 218, 90, 219, 9532, 220, 61742, 221, 9474, 222, 9618, 223, 61753, 224, 160, 225, 9612, 226, 9604, 227, 9620, 228, 9601, 229, 9615, 230, 9618, 231, 9621, 232, 61743, 233, 61754, 234, 61744, 235, 9500, 236, 61748, 237, 9492, 238, 9488, 239, 9602, 240, 9484, 241, 9524, 242, 9516, 243, 9508, 244, 9614, 245, 9613, 246, 61745, 247, 61746, 248, 61747, 249, 9603, 250, 10003, 251, 61749, 252, 61750, 253, 9496, 254, 61751, 255, 9618};
    private static Object[] petsciiTable_upper = new Object[]{5, 61696, 8, 61720, 9, 61721, 13, 13, 14, 14, 17, 61724, 18, 61722, 19, 61728, 20, 127, 28, 61697, 29, 61725, 30, 61698, 31, 61699, 32, 32, 33, 33, 34, 34, 35, 35, 36, 36, 37, 37, 38, 38, 39, 39, 40, 40, 41, 41, 42, 42, 43, 43, 44, 44, 45, 45, 46, 46, 47, 47, 48, 48, 49, 49, 50, 50, 51, 51, 52, 52, 53, 53, 54, 54, 55, 55, 56, 56, 57, 57, 58, 58, 59, 59, 60, 60, 61, 61, 62, 62, 63, 63, 64, 64, 65, 65, 66, 66, 67, 67, 68, 68, 69, 69, 70, 70, 71, 71, 72, 72, 73, 73, 74, 74, 75, 75, 76, 76, 77, 77, 78, 78, 79, 79, 80, 80, 81, 81, 82, 82, 83, 83, 84, 84, 85, 85, 86, 86, 87, 87, 88, 88, 89, 89, 90, 90, 91, 91, 92, 163, 93, 93, 94, 8593, 95, 8592, 96, 9473, 97, 9824, 98, 9474, 99, 9473, 100, 61730, 101, 61731, 102, 61732, 103, 61734, 104, 61736, 105, 9582, 106, 9584, 107, 9583, 108, 61738, 109, 9586, 110, 9585, 111, 61739, 112, 61740, 113, 9679, 114, 61733, 115, 9829, 116, 61735, 117, 9581, 118, 9587, 119, 9675, 120, 9827, 121, 61737, 122, 9830, 123, 9532, 124, 61742, 125, 9474, 126, 960, 127, 9701, 129, 61700, 133, 61712, 134, 61714, 135, 61716, 136, 61718, 137, 61713, 138, 61715, 139, 61717, 140, 61719, 141, 10, 142, 15, 144, 61701, 145, 61726, 146, 61723, 147, 12, 148, 61729, 149, 61702, 150, 61703, 151, 61704, 152, 61705, 153, 61706, 154, 61707, 155, 61708, 156, 61709, 157, 61725, 158, 61710, 159, 61711, 160, 160, 161, 9612, 162, 9604, 163, 9620, 164, 9601, 165, 9615, 166, 9618, 167, 9621, 168, 61743, 169, 9700, 170, 61744, 171, 9500, 172, 61748, 173, 9492, 174, 9488, 175, 9602, 176, 9484, 177, 9524, 178, 9516, 179, 9508, 180, 9614, 181, 9613, 182, 61745, 183, 61746, 184, 61747, 185, 9603, 186, 61741, 187, 61749, 188, 61750, 189, 9496, 190, 61751, 191, 61752, 192, 9473, 193, 9824, 194, 9474, 195, 9473, 196, 61730, 197, 61731, 198, 61732, 199, 61734, 200, 61736, 201, 9582, 202, 9584, 203, 9583, 204, 61738, 205, 9586, 206, 9585, 207, 61739, 208, 61740, 209, 9679, 210, 61733, 211, 9829, 212, 61735, 213, 9581, 214, 9587, 215, 9675, 216, 9827, 217, 61737, 218, 9830, 219, 9532, 220, 61742, 221, 9474, 222, 960, 223, 9701, 224, 160, 225, 9612, 226, 9604, 227, 9620, 228, 9601, 229, 9615, 230, 9618, 231, 9621, 232, 61743, 233, 9700, 234, 61744, 235, 9500, 236, 61748, 237, 9492, 238, 9488, 239, 9602, 240, 9484, 241, 9524, 242, 9516, 243, 9508, 244, 9614, 245, 9613, 246, 61745, 247, 61746, 248, 61747, 249, 9603, 250, 61741, 251, 61749, 252, 61750, 253, 9496, 254, 61751, 255, 960};
    private static Map<String, Map<Character, Byte>> encodingNameToTable;
    private static Map<Character, Byte> charToPetscii_mixed;
    private static Map<Character, Byte> charToPetscii_upper;
    private static Map<Character, Byte> charToScreenCode_mixed;
    private static Map<Character, Byte> charToScreenCode_upper;
    private static Map<Character, Byte> currentConversionTable;

    private static Map<Character, Byte> createMap(Object[] objectArray, boolean bl) {
        HashMap<Character, Byte> hashMap = new HashMap<Character, Byte>();
        int n = 0;
        while (n < objectArray.length) {
            int n2 = (Integer)objectArray[n++];
            if (bl) {
                n2 = CharToPetsciiConverter.petsciiToScreenCode(n2);
            }
            Character c = Character.valueOf(Character.toChars((Integer)objectArray[n++])[0]);
            hashMap.put(c, Integer.valueOf(n2).byteValue());
        }
        return hashMap;
    }

    private static int petsciiToScreenCode(int n) {
        if (n < 32) {
            n += 128;
        } else if (n >= 64) {
            if (n < 96) {
                n -= 64;
            } else if (n < 128) {
                n -= 32;
            } else if (n < 160) {
                n += 64;
            } else if (n < 192) {
                n -= 64;
            } else if (n < 224) {
                n -= 128;
            } else if (n < 255) {
                n -= 128;
            } else if (n == 255) {
                n = 94;
            } else {
                throw new RuntimeException("Unknown byte value : " + n);
            }
        }
        return n;
    }

    public static byte convert(char c, boolean bl) {
        Byte by = CharToPetsciiConverter.convert(c);
        if (by == null && bl) {
            by = (byte)c;
        }
        return by;
    }

    public static boolean setCurrentEncoding(String string) {
        Map<Character, Byte> map = encodingNameToTable.get(string);
        if (map == null) {
            return false;
        }
        currentConversionTable = map;
        return true;
    }

    public static Byte convert(char c) {
        return currentConversionTable.get(Character.valueOf(c));
    }

    static {
        charToPetscii_mixed = CharToPetsciiConverter.createMap(petsciiTable_mixed, false);
        charToPetscii_upper = CharToPetsciiConverter.createMap(petsciiTable_upper, false);
        charToScreenCode_mixed = CharToPetsciiConverter.createMap(petsciiTable_mixed, true);
        charToScreenCode_upper = CharToPetsciiConverter.createMap(petsciiTable_upper, true);
        currentConversionTable = charToScreenCode_mixed;
        encodingNameToTable = new HashMap<String, Map<Character, Byte>>();
        encodingNameToTable.put("petscii_mixed", charToPetscii_mixed);
        encodingNameToTable.put("petscii_upper", charToPetscii_upper);
        encodingNameToTable.put("screencode_mixed", charToScreenCode_mixed);
        encodingNameToTable.put("screencode_upper", charToScreenCode_upper);
    }
}

